/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.config.ProxyComponent;
import edu.wisc.my.webproxy.beans.filtering.HtmlParser;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class NekoHtmlParser
implements HtmlParser,
ProxyComponent {
    private static final Log log = LogFactory.getLog(NekoHtmlParser.class);
    private boolean insertDoctype = true;
    private boolean balanceTags = false;
    private boolean scriptStripComment = true;
    private boolean stripComments = true;
    private boolean reportErrors = false;

    @Override
    public XMLReader getReader(LexicalHandler myHandler) {
        SAXParser defaultParser = new SAXParser();
        try {
            defaultParser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)myHandler);
            defaultParser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)"UTF-8");
            defaultParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
            defaultParser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
            defaultParser.setFeature("http://cyberneko.org/html/features/report-errors", this.reportErrors);
            defaultParser.setFeature("http://cyberneko.org/html/features/insert-doctype", this.insertDoctype);
            defaultParser.setFeature("http://cyberneko.org/html/features/balance-tags", this.balanceTags);
            defaultParser.setFeature("http://cyberneko.org/html/features/scanner/script/strip-comment-delims", this.scriptStripComment);
            defaultParser.setFeature("http://cyberneko.org/html/features/scanner/style/strip-comment-delims", this.stripComments);
            defaultParser.setFeature("http://cyberneko.org/html/features/scanner/script/strip-cdata-delims", true);
            defaultParser.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
            defaultParser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        }
        catch (SAXNotRecognizedException e) {
            log.debug((Object)"SaxParser not recognized:  ", (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            log.debug((Object)"SaxParser not supported:  ", (Throwable)e);
        }
        return defaultParser;
    }

    @Override
    public String getName() {
        return "NekoHtml Filter";
    }

    @Override
    public void setRenderData(RenderRequest request, RenderResponse response) {
        PortletPreferences pp = request.getPreferences();
        this.reportErrors = new Boolean(pp.getValue("reportErrors", null));
        this.balanceTags = new Boolean(pp.getValue("balanceTags", null));
        this.insertDoctype = new Boolean(pp.getValue("insertDoctype", null));
        this.scriptStripComment = new Boolean(pp.getValue("scriptStripComment", null));
        this.stripComments = new Boolean(pp.getValue("stripComments", null));
    }

    @Override
    public void setActionData(ActionRequest request, ActionResponse response) {
    }

    @Override
    public void clearData() {
    }
}

