/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.interceptors;

import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UserInfoParameterizingPreInterceptor
implements PreInterceptor {
    protected final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void intercept(HttpServletRequest req, HttpServletResponse res, Request httpReq) {
        this.log.warn((Object)"Invoking intercept() with HttpServletRequest/HttpServletResponse;  Tokens cannot be rewritten since there is no access to the PortletRequest.USER_INFO map.");
    }

    protected String resolveTokens(PortletRequest req, String input, Strategy strategy) {
        String rslt = input;
        Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
        for (Map.Entry y : userInfo.entrySet()) {
            String inject;
            String key = (String)y.getKey();
            String value = (String)y.getValue();
            String token = "{" + key + "}";
            try {
                inject = strategy.execute(key, value);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to resolve tokens", e);
            }
            while (rslt.contains(token)) {
                rslt = rslt.replace(token, inject);
            }
        }
        return rslt;
    }

    protected static enum Strategy {
        REPLACE{

            @Override
            public String execute(String paramName, String value) throws UnsupportedEncodingException {
                return URLEncoder.encode(value, "UTF-8");
            }
        }
        ,
        EXPAND{

            @Override
            public String execute(String paramName, String value) throws UnsupportedEncodingException {
                return URLEncoder.encode(paramName, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
            }
        };


        public abstract String execute(String var1, String var2) throws UnsupportedEncodingException;
    }
}

