/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.config;

import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.ConfigurationException;
import edu.wisc.my.webproxy.beans.config.JspConfigPage;
import edu.wisc.my.webproxy.beans.interceptors.PostInterceptor;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class GeneralConfigImpl
extends JspConfigPage {
    private static final String GENERAL_PREF_PREFIX = "webproxy.general.config.";
    public static final String BASE_URL = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("sBaseUrl").toString();
    public static final String EDIT_URL = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("sEditUrl").toString();
    public static final String PORTLET_URL_REWRITE_MASKS = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("sPortletUrl").toString();
    public static final String PORTLET_URL_REWRITE_STATES = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("sPortletState").toString();
    public static final String PORTLET_URL_LIST_TYPE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("sListType").toString();
    public static final String FNAME_URL_REWRITE_MASKS = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("funcNameUrlRegEx").toString();
    public static final String FNAME_URL_REWRITE_STATES = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("funcNameUrlStates").toString();
    public static final String FNAME_URL_LIST_TYPE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("funcNameListType").toString();
    public static final String FNAME_TARGET = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("funcNameTarget").toString();
    public static final String PRE_INTERCEPTOR_CLASS = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("sPreInterceptor").toString();
    public static final String POST_INTERCEPTOR_CLASS = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.general.config.").append("sPostInterceptor").toString();
    public static final String URL_LIST_TYPE_INCLUDE = "INCLUDE";
    public static final String URL_LIST_TYPE_EXCLUDE = "EXCLUDE";

    public String getName() {
        return "General Configuration";
    }

    public void process(ActionRequest request, ActionResponse response) throws PortletException, IOException, ConfigurationException {
        StringBuffer errorMessages = new StringBuffer();
        PortletPreferences prefs = request.getPreferences();
        String baseUrl = ConfigUtils.checkEmptyNullString(request.getParameter(BASE_URL), null);
        if (baseUrl == null) {
            errorMessages.append("Base URL cannot be null\n");
        } else {
            prefs.setValue(BASE_URL, baseUrl);
        }
        String editUrl = ConfigUtils.checkEmptyNullString(request.getParameter(EDIT_URL), null);
        if (editUrl != null) {
            prefs.setValue(EDIT_URL, editUrl);
        } else {
            prefs.setValue(EDIT_URL, "");
        }
        String[] portletUrlMasks = ConfigUtils.checkNullStringArray(request.getParameterValues(PORTLET_URL_REWRITE_MASKS), new String[0]);
        String[] portletUrlStates = ConfigUtils.checkNullStringArray(request.getParameterValues(PORTLET_URL_REWRITE_STATES), new String[0]);
        if (portletUrlMasks.length == portletUrlStates.length) {
            ArrayList<String> portletUrlMaskList = new ArrayList<String>(portletUrlMasks.length);
            ArrayList<String> urlWindowStateList = new ArrayList<String>(portletUrlStates.length);
            for (int index = 0; index < portletUrlMasks.length; ++index) {
                String urlMask = ConfigUtils.checkEmptyNullString(portletUrlMasks[index], null);
                if (urlMask == null) continue;
                String windowState = ConfigUtils.checkEmptyNullString(portletUrlStates[index], null);
                portletUrlMaskList.add(ConfigUtils.checkEmptyNullString(urlMask, ""));
                urlWindowStateList.add(ConfigUtils.checkEmptyNullString(windowState, ""));
            }
            prefs.setValues(PORTLET_URL_REWRITE_MASKS, portletUrlMaskList.toArray(new String[portletUrlMaskList.size()]));
            prefs.setValues(PORTLET_URL_REWRITE_STATES, urlWindowStateList.toArray(new String[urlWindowStateList.size()]));
        } else {
            errorMessages.append("Portlet URL rewrite mask and window state lists have inconsistent lengths.\n");
        }
        String portletUrlRewriteListType = request.getParameter(PORTLET_URL_LIST_TYPE);
        if (URL_LIST_TYPE_INCLUDE.equals(portletUrlRewriteListType)) {
            prefs.setValue(PORTLET_URL_LIST_TYPE, URL_LIST_TYPE_INCLUDE);
        } else if (URL_LIST_TYPE_EXCLUDE.equals(portletUrlRewriteListType)) {
            prefs.setValue(PORTLET_URL_LIST_TYPE, URL_LIST_TYPE_EXCLUDE);
        } else {
            errorMessages.append("Invalid portlet URL rewrite list type specified '").append(portletUrlRewriteListType).append("'\n");
        }
        String[] fNameUrlMasks = ConfigUtils.checkNullStringArray(request.getParameterValues(FNAME_URL_REWRITE_MASKS), new String[0]);
        String[] fNameUrlStates = ConfigUtils.checkNullStringArray(request.getParameterValues(FNAME_URL_REWRITE_STATES), new String[0]);
        if (fNameUrlMasks.length == fNameUrlStates.length) {
            ArrayList<String> fNameUrlMaskList = new ArrayList<String>(fNameUrlMasks.length);
            ArrayList<String> urlWindowStateList = new ArrayList<String>(fNameUrlStates.length);
            for (int index = 0; index < fNameUrlMasks.length; ++index) {
                String urlMask = ConfigUtils.checkEmptyNullString(fNameUrlMasks[index], null);
                if (urlMask == null) continue;
                String windowState = ConfigUtils.checkEmptyNullString(fNameUrlStates[index], null);
                fNameUrlMaskList.add(ConfigUtils.checkEmptyNullString(urlMask, ""));
                urlWindowStateList.add(ConfigUtils.checkEmptyNullString(windowState, ""));
            }
            prefs.setValues(FNAME_URL_REWRITE_MASKS, fNameUrlMaskList.toArray(new String[fNameUrlMaskList.size()]));
            prefs.setValues(FNAME_URL_REWRITE_STATES, urlWindowStateList.toArray(new String[urlWindowStateList.size()]));
        } else {
            errorMessages.append("fName URL rewrite mask and window state lists have inconsistent lengths.\n");
        }
        String fNameUrlRewriteListType = request.getParameter(FNAME_URL_LIST_TYPE);
        if (URL_LIST_TYPE_INCLUDE.equals(fNameUrlRewriteListType)) {
            prefs.setValue(FNAME_URL_LIST_TYPE, URL_LIST_TYPE_INCLUDE);
        } else if (URL_LIST_TYPE_EXCLUDE.equals(fNameUrlRewriteListType)) {
            prefs.setValue(FNAME_URL_LIST_TYPE, URL_LIST_TYPE_EXCLUDE);
        } else {
            errorMessages.append("Invalid fName URL rewrite list type specified '").append(fNameUrlRewriteListType).append("'\n");
        }
        String fNameTarget = ConfigUtils.checkEmptyNullString(request.getParameter(FNAME_TARGET), null);
        if (fNameTarget != null) {
            prefs.setValue(FNAME_TARGET, fNameTarget);
        } else {
            prefs.setValue(FNAME_TARGET, "");
        }
        String preInterceptorClassName = ConfigUtils.checkEmptyNullString(request.getParameter(PRE_INTERCEPTOR_CLASS), null);
        if (preInterceptorClassName != null) {
            String className = "";
            try {
                Class<?> preInterceptorClass = Class.forName(preInterceptorClassName);
                PreInterceptor preInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                className = preInterceptor.getClass().getName();
            }
            catch (ClassNotFoundException cnfe) {
                errorMessages.append("Could not find specified pre-interceptor class '").append(preInterceptorClassName).append("'");
            }
            catch (InstantiationException ie) {
                errorMessages.append("Could not find specified pre-interceptor class '").append(preInterceptorClassName).append("'");
            }
            catch (IllegalAccessException iae) {
                errorMessages.append("Could not find specified pre-interceptor class '").append(preInterceptorClassName).append("'");
            }
            catch (ClassCastException cce) {
                errorMessages.append("Could not cast '").append(preInterceptorClassName).append("' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'");
            }
            prefs.setValue(PRE_INTERCEPTOR_CLASS, className);
        } else {
            prefs.setValue(PRE_INTERCEPTOR_CLASS, "");
        }
        String postInterceptorClassName = ConfigUtils.checkEmptyNullString(request.getParameter(POST_INTERCEPTOR_CLASS), null);
        if (postInterceptorClassName != null) {
            String className = "";
            try {
                Class<?> postInterceptorClass = Class.forName(postInterceptorClassName);
                PostInterceptor postInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                className = postInterceptor.getClass().getName();
            }
            catch (ClassNotFoundException cnfe) {
                errorMessages.append("Could not find specified post-interceptor class '").append(postInterceptorClassName).append("'");
            }
            catch (InstantiationException ie) {
                errorMessages.append("Could not find specified post-interceptor class '").append(postInterceptorClassName).append("'");
            }
            catch (IllegalAccessException iae) {
                errorMessages.append("Could not find specified post-interceptor class '").append(postInterceptorClassName).append("'");
            }
            catch (ClassCastException cce) {
                errorMessages.append("Could not cast '").append(postInterceptorClassName).append("' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'");
            }
            prefs.setValue(POST_INTERCEPTOR_CLASS, className);
        } else {
            prefs.setValue(POST_INTERCEPTOR_CLASS, "");
        }
        if (errorMessages.length() > 0) {
            throw new ConfigurationException(errorMessages.toString());
        }
        prefs.store();
    }
}

