/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.servlet;

import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpHeaderConfigImpl;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.IHeader;
import edu.wisc.my.webproxy.beans.http.ParameterPair;
import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.interceptors.PostInterceptor;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import edu.wisc.my.webproxy.portlet.ApplicationContextLocator;
import edu.wisc.my.webproxy.portlet.WebProxyPortlet;
import edu.wisc.my.webproxy.portlet.WebproxyConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.web.util.LRUTrackingModelPasser;
import org.jasig.web.util.ModelPasser;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProxyServlet
extends HttpServlet {
    private Log LOG = LogFactory.getLog(ProxyServlet.class);
    public static final String SESSION_ID_PARAM = "sid";
    public static final String URL_PARAM = "url";
    public static final String POST_PARAMETERS = "POST_PARAMETERS";
    public static final String HTTP_MANAGER = "HTTP_MANAGER";
    public static final String SESSION_KEY = "SESSION_KEY";
    private static final Set<String> ALLOWED_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Cache-control".toLowerCase(), "Content-Disposition".toLowerCase(), "Content-Length".toLowerCase(), "Date".toLowerCase(), "Expires".toLowerCase(), "Last-Modified".toLowerCase())));
    private final ModelPasser modelPasser = new LRUTrackingModelPasser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        ApplicationContextLocator.setApplicationContext((ApplicationContext)context);
        try {
            super.service(request, response);
        }
        finally {
            ApplicationContextLocator.setApplicationContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionKey = request.getParameter(SESSION_KEY);
        Map model = this.modelPasser.getModelFromPortlet(request, response, sessionKey);
        if (model == null) {
            response.sendError(404, "No model exists in the session for key '" + sessionKey + "'");
            return;
        }
        String requestType = (String)model.get(WebproxyConstants.REQUEST_TYPE);
        Map postParameters = (Map)model.get(POST_PARAMETERS);
        String url = (String)model.get(URL_PARAM);
        PortletPreferences prefs = (PortletPreferences)model.get(PortletPreferences.class.getName());
        HttpManager httpManager = (HttpManager)model.get(HTTP_MANAGER);
        Response httpResponse = null;
        try {
            boolean redirect = true;
            int maxRedirects = ConfigUtils.parseInt(prefs.getValue(HttpClientConfigImpl.MAX_REDIRECTS, null), 5);
            for (int index = 0; index < maxRedirects && redirect; ++index) {
                String tempUrl;
                String sPreInterceptor;
                Request httpRequest = httpManager.createRequest();
                httpRequest.setUrl(url);
                String[] headerNames = prefs.getValues(HttpHeaderConfigImpl.HEADER_NAME, new String[0]);
                String[] headerValues = prefs.getValues(HttpHeaderConfigImpl.HEADER_VALUE, new String[0]);
                if (headerNames.length == headerValues.length) {
                    ArrayList<IHeader> headerList = new ArrayList<IHeader>(headerNames.length);
                    for (int headerIndex = 0; headerIndex < headerNames.length; ++headerIndex) {
                        IHeader h = httpRequest.createHeader(headerNames[headerIndex], headerValues[headerIndex]);
                        headerList.add(h);
                    }
                    httpRequest.setHeaders(headerList.toArray(new IHeader[headerList.size()]));
                } else {
                    this.LOG.error((Object)"Invalid data in preferences. Header name array length does not equal header value array length");
                }
                if (requestType != null) {
                    httpRequest.setType(requestType);
                } else {
                    httpRequest.setType("GET");
                }
                if (postParameters != null) {
                    ArrayList<ParameterPair> postParameterPairs = new ArrayList<ParameterPair>(postParameters.size());
                    for (Map.Entry parameterEntry : postParameters.entrySet()) {
                        String paramName = (String)parameterEntry.getKey();
                        if (paramName.startsWith("edu.wisc.my.webproxy.")) continue;
                        String[] values = (String[])parameterEntry.getValue();
                        for (int valIndex = 0; valIndex < values.length; ++valIndex) {
                            ParameterPair param = new ParameterPair(paramName, values[valIndex]);
                            postParameterPairs.add(param);
                        }
                    }
                    ParameterPair[] params = postParameterPairs.toArray(new ParameterPair[postParameterPairs.size()]);
                    httpRequest.setParameters(params);
                }
                if ((sPreInterceptor = ConfigUtils.checkEmptyNullString(prefs.getValue(GeneralConfigImpl.PRE_INTERCEPTOR_CLASS, null), null)) != null) {
                    String msg;
                    try {
                        Class<?> preInterceptorClass = Class.forName(sPreInterceptor);
                        PreInterceptor myPreInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                        myPreInterceptor.intercept(request, response, httpRequest);
                    }
                    catch (ClassNotFoundException cnfe) {
                        msg = "Could not find specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)cnfe);
                        throw new ServletException(msg, (Throwable)cnfe);
                    }
                    catch (InstantiationException ie) {
                        msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)ie);
                        throw new ServletException(msg, (Throwable)ie);
                    }
                    catch (IllegalAccessException iae) {
                        msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)iae);
                        throw new ServletException(msg, (Throwable)iae);
                    }
                    catch (ClassCastException cce) {
                        msg = "Could not cast '" + sPreInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'";
                        this.LOG.error((Object)msg, (Throwable)cce);
                        throw new ServletException(msg, (Throwable)cce);
                    }
                }
                try {
                    httpResponse = httpManager.doRequest(httpRequest);
                }
                catch (HttpTimeoutException hte) {
                    this.LOG.warn((Object)("Request '" + httpRequest + "' timed out"), (Throwable)((Object)hte));
                    throw new ServletException((Throwable)((Object)hte));
                }
                String sPostInterceptor = ConfigUtils.checkEmptyNullString(prefs.getValue(GeneralConfigImpl.POST_INTERCEPTOR_CLASS, null), null);
                if (sPostInterceptor != null) {
                    String msg;
                    try {
                        Class<?> postInterceptorClass = Class.forName(sPostInterceptor);
                        PostInterceptor myPostInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                        myPostInterceptor.intercept(request, response, httpResponse);
                    }
                    catch (ClassNotFoundException cnfe) {
                        msg = "Could not find specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)cnfe);
                        throw new ServletException(msg, (Throwable)cnfe);
                    }
                    catch (InstantiationException ie) {
                        msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)ie);
                        throw new ServletException(msg, (Throwable)ie);
                    }
                    catch (IllegalAccessException iae) {
                        msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)iae);
                        throw new ServletException(msg, (Throwable)iae);
                    }
                    catch (ClassCastException cce) {
                        msg = "Could not cast '" + sPostInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'";
                        this.LOG.error((Object)msg, (Throwable)cce);
                        throw new ServletException(msg, (Throwable)cce);
                    }
                }
                if (url.equals(tempUrl = WebProxyPortlet.checkRedirect(url, httpResponse))) {
                    redirect = false;
                    continue;
                }
                url = tempUrl;
            }
            for (IHeader header : httpResponse.getHeaders()) {
                String name = header.getName();
                String value = header.getValue();
                if (!ALLOWED_HEADERS.contains(name.toLowerCase())) {
                    if (!this.LOG.isDebugEnabled()) continue;
                    this.LOG.debug((Object)("Ignoring response header: " + name + "=" + value));
                    continue;
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Copying header from request to response: " + name + "=" + value));
                }
                response.addHeader(name, value);
            }
            response.setContentType(httpResponse.getContentType());
            response.setStatus(httpResponse.getStatusCode());
            InputStream in = null;
            ServletOutputStream out = null;
            try {
                in = httpResponse.getResponseBodyAsStream();
                out = response.getOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
        finally {
            httpManager.clearData();
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("doHead not implemented");
        super.doHead(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("doPost not implemented");
        super.doPost(request, response);
    }
}

