/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.filtering.ChainingSaxFilter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseUrlFilter
extends ChainingSaxFilter {
    private static final String JAVASCRIPT_PREFIX = "JAVASCRIPT:";
    private Map<String, Set<String>> elements = Collections.emptyMap();
    private Map<String, Set<String>> passThroughElements = Collections.emptyMap();

    public BaseUrlFilter(XMLReader parent) {
        super(parent);
    }

    public BaseUrlFilter() {
    }

    public void setElements(Map<String, Set<String>> elements) {
        this.elements = this.makeCaseInsensitive(elements);
    }

    public void setPassThroughElements(Map<String, Set<String>> passThroughElements) {
        this.passThroughElements = this.makeCaseInsensitive(passThroughElements);
    }

    protected Map<String, Set<String>> makeCaseInsensitive(Map<String, Set<String>> elements) {
        TreeMap<String, Set<String>> ciElements = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, Set<String>> entry : elements.entrySet()) {
            String element = entry.getKey();
            Set<String> attributes = entry.getValue();
            TreeSet<String> ciAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            ciAttributes.addAll(attributes);
            ciElements.put(element, ciAttributes);
        }
        return ciElements;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int index;
        String sTempAtt = null;
        AttributesImpl newAtts = new AttributesImpl(atts);
        boolean getMethod = false;
        if ("FORM".equalsIgnoreCase(qName)) {
            boolean foundAction = false;
            int methodIndex = -1;
            for (index = 0; index < newAtts.getLength(); ++index) {
                if ("ACTION".equalsIgnoreCase(newAtts.getQName(index))) {
                    foundAction = true;
                }
                if (!"METHOD".equalsIgnoreCase(newAtts.getQName(index))) continue;
                methodIndex = index;
            }
            if (methodIndex != -1) {
                if ("GET".equalsIgnoreCase(newAtts.getValue(methodIndex))) {
                    getMethod = true;
                }
                newAtts.setValue(methodIndex, "POST");
            } else {
                newAtts.addAttribute(uri, "method", "method", "CDATA", "POST");
                getMethod = true;
            }
            if (!foundAction) {
                newAtts.addAttribute(uri, "ACTION", "ACTION", "CDATA", "/");
            }
        }
        boolean passThrough = false;
        Set attributes = (Set)this.elements.get(qName);
        if (attributes == null) {
            attributes = (Set)this.passThroughElements.get(qName);
            passThrough = true;
        }
        if (attributes != null) {
            for (index = 0; index < newAtts.getLength(); ++index) {
                String attrValue;
                String attrName = newAtts.getQName(index);
                if (!attributes.contains(attrName) || (attrValue = newAtts.getValue(index)) == null || attrValue.length() >= JAVASCRIPT_PREFIX.length() && JAVASCRIPT_PREFIX.equalsIgnoreCase(attrValue.substring(0, JAVASCRIPT_PREFIX.length()))) continue;
                sTempAtt = this.rewriteUrl(attrValue, passThrough);
                newAtts.setValue(index, sTempAtt);
            }
        }
        super.startElement(uri, localName, qName, (Attributes)newAtts);
        if (getMethod) {
            AttributesImpl methodAtt = new AttributesImpl();
            methodAtt.addAttribute(uri, "type", "type", "CDATA", "HIDDEN");
            methodAtt.addAttribute(uri, "name", "name", "CDATA", "edu.wisc.my.webproxy..getMethod");
            methodAtt.addAttribute(uri, "value", "value", "CDATA", "GET");
            super.startElement(uri, "input", "input", (Attributes)methodAtt);
            super.endElement(uri, "input", "input");
        }
    }

    public abstract String rewriteUrl(String var1, boolean var2);

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        super.characters(ch, start, len);
    }

    public void clearData() {
        ChainingSaxFilter parent = (ChainingSaxFilter)super.getParent();
        parent.clearData();
        this.setParent(null);
    }
}

