/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.ehcache;

import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class EhPageCache
implements PageCache {
    private Ehcache ehcache;
    private int cacheSecondsToLiveDefault = 0;

    public Ehcache getEhcache() {
        return this.ehcache;
    }

    public void setEhcache(Ehcache ehcache) {
        this.ehcache = ehcache;
    }

    public void cachePage(String key, CacheEntry entry, boolean persistent) {
        Element element = new Element((Serializable)((Object)key), (Serializable)entry);
        if (entry.getExpirationDate() == null) {
            return;
        }
        long secondsTtl = entry.getExpirationDate().getTime() - System.currentTimeMillis() > 0L ? (entry.getExpirationDate().getTime() - System.currentTimeMillis()) / 1000L : (long)this.cacheSecondsToLiveDefault;
        element.setTimeToLive((int)Math.min(Integer.MAX_VALUE, secondsTtl));
        this.ehcache.put(element);
    }

    public CacheEntry getCachedPage(String key) {
        return this.getCachedPage(key, false);
    }

    public CacheEntry getCachedPage(String key, boolean useExpired) {
        Element element = this.ehcache.get((Serializable)((Object)key));
        if (element == null || !useExpired && element.isExpired()) {
            return null;
        }
        return (CacheEntry)element.getValue();
    }

    public CacheEntry getCachedPage(String key, int maxCacheAge) {
        Element element = this.ehcache.get((Serializable)((Object)key));
        if (element == null || System.currentTimeMillis() - element.getCreationTime() > (long)maxCacheAge) {
            return null;
        }
        return (CacheEntry)element.getValue();
    }

    public void setCacheSecondsToLiveDefault(int cacheSecondsToLiveDefault) {
        this.cacheSecondsToLiveDefault = cacheSecondsToLiveDefault;
    }
}

