/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.PortletPreferencesWrapper;
import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.IHeader;
import edu.wisc.my.webproxy.beans.http.ParameterPair;
import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.http.RequestImpl;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.http.ResponseImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.springframework.web.portlet.util.PortletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpManagerImpl
extends HttpManager {
    private static final String HTTP_CLIENT_ATTR = HttpManagerImpl.class.getName() + ".HTTP_CLIENT";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ClientConnectionManager clientConnectionManager;
    private DefaultHttpClient client;
    private SchemeRegistry schemeRegistry;

    public void setSchemeRegistry(SchemeRegistry schemeRegistry) {
        this.schemeRegistry = schemeRegistry;
    }

    public void setClientConnectionManager(ClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    @Override
    public Response doRequest(Request request) throws HttpTimeoutException, IOException {
        HttpGet method;
        String requestType = request.getType();
        int indx = requestType.indexOf(35);
        if (indx != -1) {
            requestType = requestType.substring(0, indx);
        }
        if ("GET".equals(requestType)) {
            method = new HttpGet(request.getUrl());
        } else if ("POST".equals(requestType)) {
            method = new HttpPost(request.getUrl());
            ParameterPair[] postParameters = request.getParameters();
            if (postParameters != null) {
                ArrayList<BasicNameValuePair> realParameters = new ArrayList<BasicNameValuePair>();
                for (int index = 0; index < postParameters.length; ++index) {
                    realParameters.add(new BasicNameValuePair(postParameters[index].getName(), postParameters[index].getValue()));
                }
                ((HttpPost)method).setEntity((HttpEntity)new UrlEncodedFormEntity(realParameters));
            }
        } else if ("HEAD".equals(requestType)) {
            method = new HttpHead(request.getUrl());
        } else {
            throw new IllegalArgumentException("Unknown request type '" + requestType + "'");
        }
        if (request.getHeaders() != null) {
            IHeader[] headers = request.getHeaders();
            for (int index = 0; index < headers.length; ++index) {
                method.setHeader(headers[index].getName(), headers[index].getValue());
            }
        }
        return new ResponseImpl((HttpUriRequest)method, (HttpClient)this.client);
    }

    @Override
    public Request createRequest() {
        return new RequestImpl();
    }

    @Override
    public String getName() {
        return "HTTP_Manager";
    }

    @Override
    public void clearData() {
    }

    @Override
    public void setup(PortletRequest request) {
        this.client = this.getHttpClient(request);
        PortletPreferencesWrapper prefs = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        HttpParams params = this.client.getParams();
        String httpTimeoutStr = prefs.getValue(HttpClientConfigImpl.HTTP_TIMEOUT, "");
        try {
            int httpTimeout = Integer.parseInt(httpTimeoutStr);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(httpTimeout * 1000));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String circularRedirectsStr = prefs.getValue(HttpClientConfigImpl.CIRCULAR_REDIRECTS, null);
        if (circularRedirectsStr != null) {
            params.setBooleanParameter("http.protocol.allow-circular-redirects", Boolean.valueOf(circularRedirectsStr).booleanValue());
        }
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.client.getCookieStore().addCookie(cookie);
    }

    @Override
    public void addCookies(Cookie[] cookies) {
        for (Cookie cookie : cookies) {
            this.client.getCookieStore().addCookie(cookie);
        }
    }

    @Override
    public void clearCookies() {
        this.client.getCookieStore().clear();
    }

    @Override
    public List<Cookie> getCookies() {
        return this.client.getCookieStore().getCookies();
    }

    @Override
    public Credentials getCredentials() {
        return this.client.getCredentialsProvider().getCredentials(AuthScope.ANY);
    }

    @Override
    public void setCredentials(Credentials credentials) {
        if (credentials.getUserPrincipal() == null && credentials.getPassword() == null) {
            throw new IllegalArgumentException("Both username and password are null for BASIC authentication");
        }
        this.client.getCredentialsProvider().setCredentials(AuthScope.ANY, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DefaultHttpClient getHttpClient(PortletRequest request) {
        PortletSession portletSession = request.getPortletSession();
        Object object = PortletUtils.getSessionMutex((PortletSession)portletSession);
        synchronized (object) {
            DefaultHttpClient client = (DefaultHttpClient)portletSession.getAttribute(HTTP_CLIENT_ATTR);
            if (client == null) {
                client = this.createHttpClient(request);
                HttpParams params = client.getParams();
                params.setParameter("http.protocol.element-charset", (Object)"UTF-8");
                portletSession.setAttribute(HTTP_CLIENT_ATTR, (Object)client);
            }
            return client;
        }
    }

    protected DefaultHttpClient createHttpClient(PortletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new DefaultHttpClient for " + request.getRemoteUser()));
        }
        BasicHttpParams params = new BasicHttpParams();
        ClientConnectionManager clientConnectionManager = this.createClientConnectionManager(request, (HttpParams)params);
        this.client = new DefaultHttpClient(clientConnectionManager, (HttpParams)params);
        return this.client;
    }

    protected ClientConnectionManager createClientConnectionManager(PortletRequest request, HttpParams params) {
        if (this.clientConnectionManager != null) {
            return this.clientConnectionManager;
        }
        int maxConnections = ConfigUtils.parseInt(request.getPreferences().getValue(HttpClientConfigImpl.MAX_CONNECTIONS, "50"), 50);
        int maxConnectionsPerRoute = ConfigUtils.parseInt(request.getPreferences().getValue(HttpClientConfigImpl.MAX_CONNECTIONS_PER_ROUTE, "10"), 10);
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager(this.schemeRegistry, 300L, TimeUnit.SECONDS);
        threadSafeClientConnManager.setMaxTotal(maxConnections);
        threadSafeClientConnManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
        return threadSafeClientConnManager;
    }
}

