/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.PortletPreferencesWrapper;
import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.http.CookieKey;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.ICookie;
import edu.wisc.my.webproxy.beans.http.IKeyManager;
import edu.wisc.my.webproxy.beans.http.IWebProxyState;
import edu.wisc.my.webproxy.beans.http.IWebProxyStateDao;
import edu.wisc.my.webproxy.beans.http.PersistedCookieImpl;
import edu.wisc.my.webproxy.beans.http.WebProxyStateImpl;
import edu.wisc.my.webproxy.portlet.ApplicationContextLocator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.springframework.context.ApplicationContext;
import org.springframework.web.portlet.util.PortletUtils;

public class HttpManagerService {
    private static final String COOKIES = HttpManagerService.class.getName() + ".COOKIES";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IWebProxyStateDao webProxyStateDao;
    private IKeyManager keyManager;

    public void setWebProxyStateDao(IWebProxyStateDao webProxyStateDao) {
        this.webProxyStateDao = webProxyStateDao;
    }

    public void setKeyManager(IKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpManager findManager(PortletRequest request) {
        ApplicationContext context = ApplicationContextLocator.getApplicationContext();
        PortletSession session = request.getPortletSession();
        PortletPreferencesWrapper prefs = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        String sharedStateKey = ConfigUtils.checkEmptyNullString(prefs.getValue(HttpClientConfigImpl.SHARED_SESSION_KEY, null), null);
        Object object = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            HttpManager httpManager = sharedStateKey != null ? (HttpManager)session.getAttribute(sharedStateKey, 1) : (HttpManager)session.getAttribute("current_state");
            if (httpManager == null) {
                String stateKey;
                IWebProxyState state;
                httpManager = (HttpManager)context.getBean("HttpManagerBean", HttpManager.class);
                if (sharedStateKey != null) {
                    session.setAttribute(sharedStateKey, (Object)httpManager, 1);
                } else {
                    session.setAttribute("current_state", (Object)httpManager);
                }
                httpManager.setup(request);
                boolean sessionPersistenceEnabled = new Boolean(prefs.getValue(HttpClientConfigImpl.SESSION_PERSISTENCE_ENABLE, null));
                if (sessionPersistenceEnabled && (state = this.webProxyStateDao.getState(stateKey = sharedStateKey != null ? this.keyManager.generateStateKey(sharedStateKey, request) : this.keyManager.generateStateKey("current_state", request))) != null) {
                    ReadWriteLock cookieLock = httpManager.getCookieLock();
                    Lock readLock = cookieLock.readLock();
                    readLock.lock();
                    try {
                        for (ICookie cookie : state.getCookies()) {
                            if (cookie == null) continue;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Loaded persistent coookie: " + cookie));
                            }
                            BasicClientCookie c = new BasicClientCookie(cookie.getName(), cookie.getValue());
                            c.setComment(cookie.getComment());
                            c.setDomain(cookie.getDomain());
                            c.setExpiryDate(cookie.getExpiryDate());
                            c.setPath(cookie.getPath());
                            c.setSecure(cookie.isSecure());
                            c.setVersion(cookie.getVersion());
                            httpManager.addCookie((Cookie)c);
                        }
                    }
                    finally {
                        readLock.unlock();
                    }
                }
            }
            return httpManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveHttpManager(PortletRequest request, HttpManager httpManager) {
        PortletPreferencesWrapper prefs = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        boolean sessionPersistenceEnabled = new Boolean(prefs.getValue(HttpClientConfigImpl.SESSION_PERSISTENCE_ENABLE, null));
        if (sessionPersistenceEnabled) {
            String sharedStateKey = ConfigUtils.checkEmptyNullString(prefs.getValue(HttpClientConfigImpl.SHARED_SESSION_KEY, null), null);
            String stateKey = sharedStateKey != null ? this.keyManager.generateStateKey(sharedStateKey, request) : this.keyManager.generateStateKey("current_state", request);
            ReadWriteLock cookieLock = httpManager.getCookieLock();
            Lock writeLock = cookieLock.writeLock();
            writeLock.lock();
            IWebProxyState state = this.getOrCreateState(request, stateKey);
            try {
                List<ICookie> cookies = state.getCookies();
                int originalCookieCount = cookies.size();
                LinkedHashMap<CookieKey, ICookie> existingCookies = new LinkedHashMap<CookieKey, ICookie>();
                Iterator<ICookie> cookieItr = cookies.iterator();
                while (cookieItr.hasNext()) {
                    ICookie cookie = cookieItr.next();
                    if (cookie == null) {
                        cookieItr.remove();
                        continue;
                    }
                    existingCookies.put(new CookieKey(cookie.getName(), cookie.getDomain()), cookie);
                }
                Date now = new Date();
                for (Cookie cookie : httpManager.getCookies()) {
                    String domain;
                    if (cookie.isExpired(now) || !cookie.isPersistent()) continue;
                    String name = cookie.getName();
                    CookieKey key = new CookieKey(name, domain = cookie.getDomain());
                    ICookie existingCookie = (ICookie)existingCookies.remove(key);
                    if (existingCookie != null) {
                        existingCookie.setComment(cookie.getComment());
                        existingCookie.setExpiryDate(cookie.getExpiryDate());
                        existingCookie.setPath(cookie.getPath());
                        existingCookie.setSecure(cookie.isSecure());
                        existingCookie.setValue(cookie.getValue());
                        existingCookie.setVersion(cookie.getVersion());
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Updated existing persistent cookie: " + existingCookie));
                        continue;
                    }
                    PersistedCookieImpl c = new PersistedCookieImpl(name, domain);
                    c.setComment(cookie.getComment());
                    c.setExpiryDate(cookie.getExpiryDate());
                    c.setPath(cookie.getPath());
                    c.setSecure(cookie.isSecure());
                    c.setValue(cookie.getValue());
                    c.setVersion(cookie.getVersion());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Created new persistent cookie: " + c));
                    }
                    cookies.add(c);
                }
                cookies.removeAll(existingCookies.values());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Storing cookie changes old cookie count: " + originalCookieCount + ", current cookie count: " + cookies.size()));
                }
                state.setCookies(cookies);
                this.webProxyStateDao.saveState(state);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWebProxyState getOrCreateState(PortletRequest request, String stateKey) {
        PortletSession portletSession = request.getPortletSession();
        Object object = PortletUtils.getSessionMutex((PortletSession)portletSession);
        synchronized (object) {
            IWebProxyState state = this.webProxyStateDao.getState(stateKey);
            if (state == null) {
                state = new WebProxyStateImpl(stateKey);
                this.webProxyStateDao.saveState(state);
            }
            return state;
        }
    }
}

