/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.interceptors;

import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfoUrlParameterizingPreInterceptor
implements PreInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void intercept(RenderRequest req, RenderResponse res, Request httpReq) {
        this.updateUri((PortletRequest)req, httpReq);
    }

    @Override
    public void intercept(ActionRequest req, ActionResponse res, Request httpReq) {
        this.updateUri((PortletRequest)req, httpReq);
    }

    @Override
    public void intercept(HttpServletRequest req, HttpServletResponse res, Request httpReq) {
        this.log.warn((Object)"Invoking intercept() with HttpServletRequest/HttpServletResponse;  URL parameters cannot be rewritten since there is no access to the PortletRequest.USER_INFO map.");
    }

    private void updateUri(PortletRequest req, Request httpResp) {
        Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
        String uri = httpResp.getUrl();
        this.log.debug((Object)("Supplied URL:  " + uri));
        try {
            String newUri = this.injectUriParameters(uri, userInfo);
            this.log.debug((Object)("URL after processing parameters:  " + newUri));
            httpResp.setUrl(newUri);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String injectUriParameters(String uri, Map<String, String> params) throws UnsupportedEncodingException {
        String inject;
        String requestUri = null;
        String queryString = "";
        int queryStringBegin = uri.indexOf("?");
        if (queryStringBegin == -1) {
            requestUri = uri;
        } else {
            requestUri = uri.substring(0, queryStringBegin);
            queryString = uri.substring(queryStringBegin);
        }
        for (Map.Entry<String, String> y : params.entrySet()) {
            String token = "{" + y.getKey() + "}";
            String value = y.getValue();
            inject = URLEncoder.encode(value, "UTF-8");
            while (requestUri.contains(token)) {
                requestUri = requestUri.replace(token, inject);
            }
        }
        for (Map.Entry<String, String> y : params.entrySet()) {
            String paramName = y.getKey();
            String token = "{" + paramName + "}";
            if (!queryString.contains(token)) continue;
            inject = URLEncoder.encode(paramName, "UTF-8") + "=" + URLEncoder.encode(y.getValue(), "UTF-8");
            queryString = queryString.replace(token, inject);
        }
        return requestUri + queryString;
    }
}

