/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.config.ClippingConfigImpl;
import edu.wisc.my.webproxy.beans.filtering.ChainingSaxFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClippingFilter
extends ChainingSaxFilter {
    private static final Log LOG = LogFactory.getLog(ClippingFilter.class);
    List<List<String>> xPath = null;
    List<String> currentPath = new LinkedList();
    private Set notAcceptable = null;
    private String[] sElement = null;
    private Map<String, String> comments = new HashMap();
    private boolean commentMatch = false;
    private boolean xPathMatch = false;
    private boolean elementMatch = false;
    private boolean disable = true;

    public ClippingFilter() {
    }

    public ClippingFilter(XMLReader parent) {
        super(parent);
    }

    public void setXPath(String[] path) {
        this.xPath = new ArrayList(path.length);
        for (int pathIndex = 0; pathIndex < path.length; ++pathIndex) {
            LinkedList<String> pathPartList = new LinkedList<String>();
            this.xPath.add(pathPartList);
            StringTokenizer st = new StringTokenizer(path[pathIndex], "/");
            while (st.hasMoreTokens()) {
                pathPartList.add(st.nextToken());
            }
        }
    }

    public void setElement(String[] newElement) {
        this.sElement = newElement;
    }

    public void setComments(String[] newComments) {
        for (int index = 0; index < newComments.length; ++index) {
            this.comments.put(newComments[index], "off");
        }
    }

    public List<List<String>> getXPath() {
        return this.xPath;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.disable) {
            this.currentPath.add(qName);
            if (this.xPath != null) {
                for (List pathPartList : this.xPath) {
                    for (int myPathIndex = 0; myPathIndex < pathPartList.size() && myPathIndex < this.currentPath.size(); ++myPathIndex) {
                        String currentPathPart = (String)this.currentPath.get(myPathIndex);
                        String testPathPart = (String)pathPartList.get(myPathIndex);
                        if (myPathIndex < this.currentPath.size() && currentPathPart != null && currentPathPart.equalsIgnoreCase(testPathPart)) {
                            this.xPathMatch = true;
                            if (myPathIndex != pathPartList.size() - 1) continue;
                            break;
                        }
                        this.xPathMatch = false;
                        break;
                    }
                    if (this.xPathMatch && this.currentPath.size() >= pathPartList.size()) break;
                    this.xPathMatch = false;
                }
            }
            if (this.sElement != null) {
                for (String testElement : this.sElement) {
                    if (this.currentPath.contains(testElement)) {
                        this.elementMatch = true;
                        break;
                    }
                    this.elementMatch = false;
                }
            }
            if (this.xPathMatch || this.elementMatch || this.commentMatch) {
                super.startElement(uri, localName, qName, atts);
            }
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.disable) {
            if (this.xPath != null) {
                for (List pathPartList : this.xPath) {
                    for (int myPathIndex = 0; myPathIndex < pathPartList.size() && myPathIndex < this.currentPath.size(); ++myPathIndex) {
                        String currentPathPart = (String)this.currentPath.get(myPathIndex);
                        String testPathPart = (String)pathPartList.get(myPathIndex);
                        if (myPathIndex < this.currentPath.size() && currentPathPart != null && currentPathPart.equalsIgnoreCase(testPathPart)) {
                            this.xPathMatch = true;
                            if (myPathIndex != pathPartList.size() - 1) continue;
                            break;
                        }
                        this.xPathMatch = false;
                        break;
                    }
                    if (this.xPathMatch && this.currentPath.size() >= pathPartList.size()) break;
                    this.xPathMatch = false;
                }
            }
            if (this.sElement != null) {
                for (String testElement : this.sElement) {
                    if (this.currentPath.contains(testElement)) {
                        this.elementMatch = true;
                        break;
                    }
                    this.elementMatch = false;
                }
            }
            if (this.xPathMatch || this.elementMatch || this.commentMatch) {
                super.endElement(uri, localName, qName);
            }
            boolean removeFromXPath = true;
            for (int index = this.currentPath.size(); index > 0 && removeFromXPath; --index) {
                String tempName = (String)this.currentPath.get(index - 1);
                if (this.notAcceptable(tempName)) {
                    this.currentPath.remove(index - 1);
                    continue;
                }
                if (!tempName.equalsIgnoreCase(qName)) continue;
                this.currentPath.remove(index - 1);
                removeFromXPath = false;
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (!this.disable) {
            if (this.xPathMatch || this.elementMatch || this.commentMatch) {
                super.characters(ch, start, len);
            }
        } else {
            super.characters(ch, start, len);
        }
    }

    public void setAcceptableQNames(Set notAcceptable) {
        this.notAcceptable = notAcceptable;
    }

    public boolean notAcceptable(String qName) {
        boolean isAcceptable = false;
        if (this.notAcceptable.contains(qName) || this.notAcceptable.contains(qName.toLowerCase())) {
            isAcceptable = true;
        }
        return isAcceptable;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        String currentComment = new String(ch, start, length);
        if (this.comments.containsKey(currentComment)) {
            String commentStatus = (String)this.comments.get(currentComment);
            if (commentStatus.equals("off")) {
                this.comments.put(currentComment, "on");
            } else {
                this.comments.put(currentComment, "off");
            }
            this.commentMatch = this.comments.containsValue("on");
        }
        if (!this.disable) {
            if (this.xPathMatch || this.elementMatch || this.commentMatch) {
                super.comment(ch, start, length);
            }
        } else {
            super.comment(ch, start, length);
        }
    }

    public String getName() {
        return "Clipping Filter";
    }

    public void setRenderData(RenderRequest request, RenderResponse response) {
        this.setupFilter((PortletRequest)request);
        super.setRenderData(request, response);
    }

    public void setActionData(ActionRequest request, ActionResponse response) {
        this.setupFilter((PortletRequest)request);
        super.setActionData(request, response);
    }

    private void setupFilter(PortletRequest request) {
        PortletPreferences pp = request.getPreferences();
        String[] sTemp = null;
        sTemp = pp.getValues(ClippingConfigImpl.XPATH, null);
        if (sTemp != null) {
            this.setXPath(sTemp);
        }
        if ((sTemp = pp.getValues(ClippingConfigImpl.ELEMENT, null)) != null) {
            this.setElement(sTemp);
        }
        if ((sTemp = pp.getValues(ClippingConfigImpl.COMMENT, null)) != null) {
            this.setComments(sTemp);
        }
        this.disable = new Boolean(pp.getValue(ClippingConfigImpl.DISABLE, null)) == false;
    }
}

