/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.config;

import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.JspConfigPage;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class ClippingConfigImpl
extends JspConfigPage {
    private static final String CLIPPING_PREF_PREFIX = "webproxy.clipping.";
    public static final String DISABLE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.clipping.").append("sClippingDisable").toString();
    public static final String XPATH = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.clipping.").append("sXPath").toString();
    public static final String COMMENT = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.clipping.").append("sComment").toString();
    public static final String ELEMENT = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.clipping.").append("sElement").toString();

    @Override
    public String getName() {
        return "Clipping Configuration";
    }

    @Override
    public void process(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletPreferences prefs = request.getPreferences();
        Boolean useCache = new Boolean(request.getParameter(DISABLE));
        prefs.setValue(DISABLE, useCache.toString());
        String[] paths = ConfigUtils.checkNullStringArray(request.getParameterValues(XPATH), new String[0]);
        String[] trimmedPaths = this.parseArray(paths);
        prefs.setValues(XPATH, trimmedPaths);
        String[] comments = ConfigUtils.checkNullStringArray(request.getParameterValues(COMMENT), new String[0]);
        String[] trimmedComments = this.parseArray(comments);
        prefs.setValues(COMMENT, trimmedComments);
        String[] elements = ConfigUtils.checkNullStringArray(request.getParameterValues(ELEMENT), new String[0]);
        String[] trimmedElements = this.parseArray(elements);
        prefs.setValues(ELEMENT, trimmedElements);
        prefs.store();
    }

    private String[] parseArray(String[] data) {
        ArrayList<String> dataList = new ArrayList<String>(data.length);
        for (String item : data) {
            String d = ConfigUtils.checkEmptyNullString(item, null);
            if (d == null) continue;
            dataList.add(ConfigUtils.checkEmptyNullString(d, ""));
        }
        return dataList.toArray(new String[dataList.size()]);
    }
}

