/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.config;

import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.ConfigurationException;
import edu.wisc.my.webproxy.beans.config.JspConfigPage;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class HttpHeaderConfigImpl
extends JspConfigPage {
    private static final String HTTPHEADER_PREF_PREFIX = "webproxy.httpheader.";
    public static final String HEADER_NAME = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpheader.").append("sHeaderName").toString();
    public static final String HEADER_VALUE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpheader.").append("sHeaderValue").toString();

    @Override
    public String getName() {
        return "HTTP Header Configuration";
    }

    @Override
    public void process(ActionRequest request, ActionResponse response) throws PortletException, IOException, ConfigurationException {
        StringBuffer errorMessages = new StringBuffer();
        PortletPreferences prefs = request.getPreferences();
        String[] headerNames = ConfigUtils.checkNullStringArray(request.getParameterValues(HEADER_NAME), new String[]{"", "", ""});
        String[] headerValues = ConfigUtils.checkNullStringArray(request.getParameterValues(HEADER_VALUE), new String[]{"", "", ""});
        if (headerNames.length == headerValues.length) {
            ArrayList<String> headerNamesList = new ArrayList<String>(headerNames.length);
            ArrayList<String> headerValuesList = new ArrayList<String>(headerValues.length);
            for (int index = 0; index < headerNames.length; ++index) {
                String name = ConfigUtils.checkEmptyNullString(headerNames[index], null);
                if (name == null) continue;
                String value = ConfigUtils.checkEmptyNullString(headerValues[index], null);
                headerNamesList.add(ConfigUtils.checkEmptyNullString(name, ""));
                headerValuesList.add(ConfigUtils.checkEmptyNullString(value, ""));
            }
            prefs.setValues(HEADER_NAME, headerNamesList.toArray(new String[headerNamesList.size()]));
            prefs.setValues(HEADER_VALUE, headerValuesList.toArray(new String[headerValuesList.size()]));
        } else {
            errorMessages.append("Header name and value lists have inconsistent lengths.\n");
        }
        if (errorMessages.length() > 0) {
            throw new ConfigurationException(errorMessages.toString());
        }
        prefs.store();
    }
}

