/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.filtering.InclExclUrlFilter;
import edu.wisc.my.webproxy.portlet.WebproxyConstants;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.XMLReader;

public final class PortletUrlFilter
extends InclExclUrlFilter {
    private static final Log log = LogFactory.getLog(PortletUrlFilter.class);
    private String[] urlStateList = null;
    private RenderResponse renderResponse = null;

    public PortletUrlFilter() {
    }

    public PortletUrlFilter(XMLReader parent) {
        super(parent);
    }

    @Override
    protected String doUrlRewite(String orignialUrl, int matchIndex, boolean passThrough) {
        PortletURL newUrl = this.renderResponse.createActionURL();
        newUrl.setParameter(WebproxyConstants.BASE_URL, orignialUrl);
        if (passThrough) {
            newUrl.setParameter("edu.wisc.my.webproxy.PASS_THROUGH", Boolean.TRUE.toString());
        }
        if (matchIndex >= 0 && this.urlStateList != null && this.urlStateList[matchIndex] != null && this.urlStateList[matchIndex].trim().length() > 0) {
            try {
                newUrl.setWindowState(new WindowState(this.urlStateList[matchIndex]));
            }
            catch (WindowStateException e) {
                log.error((Object)("Unable to set WindowState='" + this.urlStateList[matchIndex] + "'"), (Throwable)e);
            }
        }
        String portletUrl = newUrl.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Re-Wrote '" + orignialUrl + "' to '" + portletUrl + "'"));
        }
        return portletUrl;
    }

    @Override
    public void setRenderData(RenderRequest request, RenderResponse response) {
        PortletPreferences pp = request.getPreferences();
        String[] urlRegExList = pp.getValues(GeneralConfigImpl.PORTLET_URL_REWRITE_MASKS, null);
        this.setUrlRegExList(urlRegExList);
        String listType = pp.getValue(GeneralConfigImpl.PORTLET_URL_LIST_TYPE, null);
        this.setListType(listType);
        this.urlStateList = pp.getValues(GeneralConfigImpl.PORTLET_URL_REWRITE_STATES, this.urlStateList);
        this.renderResponse = response;
        super.setRenderData(request, response);
    }

    @Override
    public void clearData() {
        this.setListType(null);
        this.setListType(null);
        this.renderResponse = null;
        super.clearData();
    }

    @Override
    public String getName() {
        return "Portlet URL Filter";
    }

    @Override
    public void setActionData(ActionRequest request, ActionResponse response) {
        throw new IllegalStateException("PortletUrlFilter is invalid to use during an action");
    }
}

