/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.ICookie;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="WP_COOKIE")
@GenericGenerator(name="WP_COOKIE_ID_GEN", strategy="native", parameters={@Parameter(name="sequence", value="WP_COOKIE_ID_SEQ"), @Parameter(name="table", value="WP_JPA_UNIQUE_KEY"), @Parameter(name="column", value="NEXT_WP_COOKIE_ID_HI")})
public class PersistedCookieImpl
implements ICookie,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="WP_COOKIE_ID_GEN")
    @Column(name="COOKIE_ID")
    private final long cookieId;
    @Column(name="COOKIE_NAME", length=4000, nullable=false)
    private final String name;
    @Column(name="DOMAIN", length=1000)
    private final String domain;
    @Column(name="COOKIE_VALUE", length=4000)
    private String value;
    @Column(name="PATH", length=1000)
    private String path;
    @Column(name="EXPIRY_DATE")
    private Date expiryDate;
    @Column(name="COOKIE_COMMENT", length=4000)
    private String comment;
    @Column(name="SECURE")
    private boolean secure;
    @Column(name="VERSION")
    private int version;
    @Column(name="CREATE_DATETIME")
    private Date created;
    @Column(name="UPDATE_DATETIME")
    private Date updated;

    @PrePersist
    protected void onCreate() {
        this.created = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updated = new Date();
    }

    private PersistedCookieImpl() {
        this.cookieId = -1L;
        this.name = null;
        this.domain = null;
    }

    public PersistedCookieImpl(String name, String domain) {
        Validate.notNull((Object)name, (String)"name cannot be null");
        this.cookieId = -1L;
        this.name = name;
        this.domain = domain;
    }

    @Override
    public boolean isExpired() {
        return this.expiryDate != null && this.expiryDate.before(new Date());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public String toString() {
        return "PersistedCookieImpl [cookieId=" + this.cookieId + ", domain=" + this.domain + ", path=" + this.path + ", expiryDate=" + this.expiryDate + ", " + "secure=" + this.secure + ", version=" + this.version + ", name=" + this.name + ", " + "value=" + this.value + ", comment=" + this.comment + ", created=" + this.created + ", updated=" + this.updated + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.expiryDate == null ? 0 : this.expiryDate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.secure ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistedCookieImpl other = (PersistedCookieImpl)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.expiryDate == null ? other.expiryDate != null : !this.expiryDate.equals(other.expiryDate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.secure != other.secure) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.version == other.version;
    }
}

