/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.IWebProxyState;
import edu.wisc.my.webproxy.beans.http.IWebProxyStateDao;
import edu.wisc.my.webproxy.beans.http.WebProxyStateImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.transaction.annotation.Transactional;

public class WebProxyStateJpaDaoImpl
implements IWebProxyStateDao {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String FIND_STATE_BY_KEY = "from WebProxyStateImpl state where state.stateKey = :stateKey";
    private static final String DELETE_EXPIRED_COOKIES = "DELETE FROM PersistedCookieImpl cookie WHERE cookie.expiryDate < :now";
    private EntityManager entityManager;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public IWebProxyState getState(String stateKey) {
        Query query = this.entityManager.createQuery(FIND_STATE_BY_KEY);
        query.setParameter("stateKey", (Object)stateKey);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)(WebProxyStateImpl.class.getName() + ".query.FIND_STATE_BY_KEY"));
        query.setMaxResults(1);
        List states = query.getResultList();
        IWebProxyState state = (IWebProxyState)DataAccessUtils.uniqueResult((Collection)states);
        return state;
    }

    @Override
    @Transactional
    public IWebProxyState saveState(IWebProxyState state) {
        this.entityManager.persist((Object)state);
        return state;
    }

    @Override
    @Transactional
    public void purgeExpiredCookies() {
        Query query = this.entityManager.createQuery(DELETE_EXPIRED_COOKIES);
        query.setParameter("now", (Object)new Date());
        int results = query.executeUpdate();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted " + results + " expired cookies"));
        }
    }
}

