/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.interceptors;

import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.interceptors.PostInterceptor;
import java.net.MalformedURLException;
import java.net.URL;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseUrlProtocolHostPortEnforcingPostInterceptor
implements PostInterceptor {
    protected final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void intercept(RenderRequest request, RenderResponse response, Response httpResponse) {
        this.enforce((PortletRequest)request, httpResponse);
    }

    @Override
    public void intercept(ActionRequest request, ActionResponse response, Response httpResponse) {
        this.enforce((PortletRequest)request, httpResponse);
    }

    @Override
    public void intercept(HttpServletRequest request, HttpServletResponse response, Response httpResponse) {
        this.log.warn((Object)"Invoking intercept() with HttpServletRequest/HttpServletResponse;  Tokens cannot be rewritten since there is no access to the PortletRequest.USER_INFO map.");
    }

    private void enforce(PortletRequest req, Response httpResponse) {
        PortletPreferences prefs = req.getPreferences();
        String baseUrlString = ConfigUtils.checkEmptyNullString(prefs.getValue(GeneralConfigImpl.BASE_URL, null), null);
        if (baseUrlString == null) {
            throw new IllegalStateException("Preference '" + GeneralConfigImpl.BASE_URL + "' not set");
        }
        try {
            URL baseUrl = new URL(baseUrlString);
            URL requestUrl = new URL(httpResponse.getRequestUrl());
            if (requestUrl.getProtocol().equals(baseUrl.getProtocol()) && requestUrl.getHost().equals(baseUrl.getHost()) && requestUrl.getPort() == baseUrl.getPort()) {
                return;
            }
            this.log.warn((Object)("Attempt to proxy '" + httpResponse.getRequestUrl() + "' from within portlet of baseUrl '" + baseUrlString + "' by user account '" + req.getRemoteUser() + "'"));
            throw new SecurityException();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

