/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.filtering.ChainingSaxFilter;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class HtmlOutputFilter
extends ChainingSaxFilter {
    private static final String ENTITY_START = "&";
    private static final String ENTITY_END = ";";
    private static final String TAG_OPEN_START = "<";
    private static final String TAG_CLOSE_START = "</";
    private static final String TAG_END = ">";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String QUOTE = "\"";
    private static final String EQUAL = "=";
    private static final String SPACE = " ";
    private final Writer out;
    private String currentEntity = null;

    public HtmlOutputFilter(Writer out) {
        if (out == null) {
            throw new IllegalArgumentException("OutputStream cannot be null");
        }
        this.out = out;
    }

    public String getName() {
        return "Output Filter";
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.out.write(COMMENT_START);
            this.out.write(ch, start, length);
            this.out.write(COMMENT_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void startEntity(String name) throws SAXException {
        this.currentEntity = name;
        try {
            this.out.write(ENTITY_START);
            this.out.write(this.currentEntity);
            this.out.write(ENTITY_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void endEntity(String name) throws SAXException {
        this.currentEntity = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.currentEntity == null) {
                String chars = new String(ch, start, length);
                this.out.write(chars);
            }
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new SAXException("Error flushing output stream", ioe);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.out.write(TAG_CLOSE_START);
            this.out.write(qName);
            this.out.write(TAG_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.out.write(TAG_OPEN_START);
            this.out.write(qName);
            for (int index = 0; index < atts.getLength(); ++index) {
                String name = atts.getQName(index);
                String value = atts.getValue(index);
                this.out.write(SPACE);
                this.out.write(name);
                if (value == null) continue;
                this.out.write(EQUAL);
                this.out.write(QUOTE);
                this.out.write(value);
                this.out.write(QUOTE);
            }
            this.out.write(TAG_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }
}

