/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.athletics.dao;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jasig.portlet.athletics.dao.IAthleticsDao;
import org.jasig.portlet.athletics.model.feed.xml.AthleticsFeed;
import org.jasig.portlet.athletics.model.feed.xml.NewsItem;
import org.jasig.portlet.athletics.model.feed.xml.Sport;

public class AthleticsDaoRomeImpl
implements IAthleticsDao {
    protected Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> newsUrls;

    @Override
    public AthleticsFeed getFeed() {
        AthleticsFeed feed = new AthleticsFeed();
        for (String sportKey : this.newsUrls.keySet()) {
            Sport sport = this.getSport(sportKey);
            if (sport == null) continue;
            feed.getSport().add(sport);
        }
        return feed;
    }

    @Override
    public Sport getSport(String sportKey) {
        Sport sport = new Sport();
        sport.setName(sportKey);
        String url = this.newsUrls.get(sportKey);
        if (url != null) {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet httpget = new HttpGet(url);
            try {
                HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                InputStream in = response.getEntity().getContent();
                XmlReader reader = new XmlReader(in);
                SyndFeedInput input = new SyndFeedInput();
                SyndFeed feed = input.build((Reader)reader);
                List entries = feed.getEntries();
                for (SyndEntry entry : entries) {
                    NewsItem item = new NewsItem();
                    item.setTitle(entry.getTitle());
                    item.setSummary(entry.getDescription().getValue());
                    sport.getNewsItem().add(item);
                }
            }
            catch (ClientProtocolException e) {
                this.log.error((Object)e);
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)e);
            }
            catch (FeedException e) {
                this.log.error((Object)e);
            }
        }
        return sport;
    }
}

