/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.athletics.dao;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jasig.portlet.athletics.dao.IAthleticsDao;
import org.jasig.portlet.athletics.model.feed.xml.AthleticsFeed;
import org.jasig.portlet.athletics.model.feed.xml.Sport;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.core.io.Resource;

public class ScreenScrapingAthleticsDaoImpl
implements IAthleticsDao {
    protected Log log = LogFactory.getLog(this.getClass());
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Resource xslt;
    private Policy policy;
    private Map<String, String> sportUrls;

    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }

    public void setPolicy(Resource config) throws PolicyException, IOException {
        this.policy = Policy.getInstance((File)config.getFile());
    }

    public void setSportUrls(Map<String, String> urlMap) {
        this.sportUrls = urlMap;
    }

    public Map<String, String> getSportUrls() {
        return this.sportUrls;
    }

    public AthleticsFeed getFeed() {
        AthleticsFeed feed = new AthleticsFeed();
        for (String sportKey : this.sportUrls.keySet()) {
            Sport sport = this.getSport(sportKey);
            if (sport == null) continue;
            feed.getSport().add(sport);
        }
        return feed;
    }

    public Sport getSport(String sportKey) {
        String url = (String)this.sportUrls.get(sportKey);
        if (url != null) {
            try {
                String html = this.getHtmlContent(url);
                String cleanHtml = this.getCleanedHtmlContent(html);
                String xml = this.getXml(cleanHtml);
                Sport sport = this.getSportForXml(xml);
                sport.setName(sportKey);
                this.postProcessSport(sport);
                return sport;
            }
            catch (ClientProtocolException e) {
                this.log.error((Object)e);
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
            catch (ScanException e) {
                this.log.error((Object)e);
            }
            catch (PolicyException e) {
                this.log.error((Object)e);
            }
            catch (TransformerException e) {
                this.log.error((Object)e);
            }
            catch (JAXBException e) {
                this.log.error((Object)e);
            }
        }
        return null;
    }

    protected String getHtmlContent(String url) throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        InputStream httpStream = response.getEntity().getContent();
        String content = IOUtils.toString((InputStream)httpStream);
        return content;
    }

    protected String getCleanedHtmlContent(String html) throws ScanException, PolicyException {
        AntiSamy as = new AntiSamy();
        CleanResults cr = as.scan(html, this.policy);
        String cleanedHtml = cr.getCleanHTML();
        String unescaped = cleanedHtml.replace("&", "&amp;");
        return unescaped;
    }

    protected String getXml(String cleanHtml) throws TransformerException, IOException {
        StreamSource xsltSource = new StreamSource(this.xslt.getInputStream());
        Transformer identityTransformer = transformerFactory.newTransformer(xsltSource);
        identityTransformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter outputWriter = new StringWriter();
        StreamResult outputTarget = new StreamResult(outputWriter);
        StreamSource xmlSource = new StreamSource(new StringReader(cleanHtml));
        identityTransformer.transform(xmlSource, outputTarget);
        String content = outputWriter.toString();
        return content;
    }

    protected Sport getSportForXml(String xml) throws JAXBException {
        String packageName = Sport.class.getPackage().getName();
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller u = jc.createUnmarshaller();
        Sport sport = (Sport)u.unmarshal(IOUtils.toInputStream((String)xml));
        return sport;
    }

    protected void postProcessSport(Sport sport) {
    }
}

