/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.athletics.dao.sample;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jasig.portlet.athletics.dao.ScreenScrapingAthleticsDaoImpl;
import org.jasig.portlet.athletics.model.feed.xml.Competition;
import org.jasig.portlet.athletics.model.feed.xml.Sport;

public class UChicagoScoresAthleticsDaoImpl
extends ScreenScrapingAthleticsDaoImpl {
    private static Pattern whitespace = Pattern.compile("\\s+");
    private static Pattern invalidNameChars = Pattern.compile("[^a-zA-Z\\(\\)\\- ]");

    protected void postProcessSport(Sport sport) {
        for (Competition competition : sport.getCompetition()) {
            String name = competition.getName().trim();
            Matcher invalidCharsMatcher = invalidNameChars.matcher(name);
            name = invalidCharsMatcher.replaceAll("");
            competition.setName(name);
            Matcher whitespaceMatcher = whitespace.matcher(name);
            name = whitespaceMatcher.replaceAll(" ");
            String url = competition.getUrl();
            if (url == null) continue;
            String sportUrl = (String)this.getSportUrls().get(sport.getName());
            String fullUrl = sportUrl.substring(0, sportUrl.lastIndexOf("/")).concat("/").concat(url);
            competition.setUrl(fullUrl);
        }
    }
}

