/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.basiclti.support;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.signature.OAuthSignatureMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAuthSupport {
    private static final Log log = LogFactory.getLog((String)OAuthSupport.class.getName());
    private static final String CHARSET = "UTF-8";

    public static Map<String, String> signProperties(String url, Map<String, String> props, String method, String key, String secret) {
        if (key == null || secret == null) {
            log.error((Object)"Error in signProperties - key and secret must be specified");
            return null;
        }
        OAuthMessage oam = new OAuthMessage(method, url, props.entrySet());
        OAuthConsumer cons = new OAuthConsumer("about:blank", key, secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            oam.addRequiredParameters(acc);
            log.info((Object)("Base Message String\n" + OAuthSignatureMethod.getBaseString((OAuthMessage)oam) + "\n"));
            List params = oam.getParameters();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Map.Entry p : params) {
                String param = URLEncoder.encode((String)p.getKey(), CHARSET);
                String value = (String)p.getValue();
                String encodedValue = value != null ? URLEncoder.encode(value, CHARSET) : "";
                headers.put(param, encodedValue);
            }
            return headers;
        }
        catch (OAuthException e) {
            log.error((Object)(((Object)((Object)e)).getClass() + ":" + e.getMessage()));
            return null;
        }
        catch (IOException e) {
            log.error((Object)(e.getClass() + ":" + e.getMessage()));
            return null;
        }
        catch (URISyntaxException e) {
            log.error((Object)(e.getClass() + ":" + e.getMessage()));
            return null;
        }
    }
}

