/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.basiclti;

import au.edu.anu.portal.portlets.basiclti.adapters.BasicLTIAdapterFactory;
import au.edu.anu.portal.portlets.basiclti.adapters.IBasicLTIAdapter;
import au.edu.anu.portal.portlets.basiclti.support.CollectionsSupport;
import au.edu.anu.portal.portlets.basiclti.support.HttpSupport;
import au.edu.anu.portal.portlets.basiclti.support.OAuthSupport;
import au.edu.anu.portal.portlets.basiclti.utils.Messages;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLTIPortlet
extends GenericPortlet {
    private final Logger log = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String viewUrl;
    private String proxyUrl;
    private String errorUrl;
    private String configUrl;
    private String editUrl;
    private String attributeMappingForUsername;
    private String attributeMappingForFirstName;
    private String attributeMappingForLastName;
    private String attributeMappingForEmail;
    private String attributeMappingForDisplayName;
    private Map<String, String> adapterClasses;
    private Cache cache;
    private CacheManager cacheManager;
    private static final String CACHE_NAME = "au.edu.anu.portal.portlets.cache.BasicLTIPortletCache";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.log.info("Basic LTI Portlet init()");
        this.viewUrl = config.getInitParameter("viewUrl");
        this.proxyUrl = config.getInitParameter("proxyUrl");
        this.errorUrl = config.getInitParameter("errorUrl");
        this.configUrl = config.getInitParameter("configUrl");
        this.editUrl = config.getInitParameter("editUrl");
        this.attributeMappingForUsername = config.getInitParameter("portal.attribute.mapping.username");
        this.attributeMappingForFirstName = config.getInitParameter("portal.attribute.mapping.firstName");
        this.attributeMappingForLastName = config.getInitParameter("portal.attribute.mapping.lastName");
        this.attributeMappingForEmail = config.getInitParameter("portal.attribute.mapping.email");
        this.attributeMappingForDisplayName = config.getInitParameter("portal.attribute.mapping.displayName");
        this.adapterClasses = this.initAdapters(config);
        this.cacheManager = new CacheManager();
        this.cache = this.cacheManager.getCache(CACHE_NAME);
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.log.info("Basic LTI doDispatch()");
        if (StringUtils.equalsIgnoreCase((String)request.getPortletMode().toString(), (String)"CONFIG")) {
            this.doConfig(request, response);
        } else {
            super.doDispatch(request, response);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.log.info("Basic LTI doView()");
        Map<String, String> launchData = this.setupLaunchData(request, response);
        if (launchData == null) {
            return;
        }
        StringBuilder proxy = new StringBuilder();
        proxy.append(request.getContextPath());
        proxy.append(this.proxyUrl);
        proxy.append("?");
        proxy.append(HttpSupport.serialiseMapToQueryString(launchData));
        request.setAttribute("proxyContextUrl", (Object)proxy.toString());
        request.setAttribute("preferredHeight", (Object)this.getConfiguredPortletHeight(request));
        this.dispatch(request, response, this.viewUrl);
    }

    protected void doConfig(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.log.info("Basic LTI doConfig()");
        request.setAttribute("configuredPortletHeight", (Object)this.getConfiguredPortletHeight(request));
        request.setAttribute("configuredPortletTitle", (Object)this.getConfiguredPortletTitle(request));
        request.setAttribute("configuredProviderType", (Object)this.getConfiguredProviderType(request));
        request.setAttribute("configuredLaunchData", (Object)this.getConfiguredLaunchData(request));
        request.setAttribute("key", (Object)this.getBasicLTIKey(request));
        request.setAttribute("secret", (Object)this.getBasicLTISecret(request));
        this.dispatch(request, response, this.configUrl);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.log.info("Basic LTI doEdit()");
        request.setAttribute("configuredPortletHeight", (Object)this.getConfiguredPortletHeight(request));
        request.setAttribute("configuredPortletTitle", (Object)this.getConfiguredPortletTitle(request));
        this.dispatch(request, response, this.editUrl);
    }

    public void processAction(ActionRequest request, ActionResponse response) {
        this.log.info("Basic LTI processAction()");
        if (StringUtils.equalsIgnoreCase((String)request.getPortletMode().toString(), (String)"CONFIG")) {
            this.processConfigAction(request, response);
        } else if (StringUtils.equalsIgnoreCase((String)request.getPortletMode().toString(), (String)"EDIT")) {
            this.processEditAction(request, response);
        } else {
            this.log.error("No handler for PortletMode: " + request.getPortletMode().toString());
        }
    }

    private void processConfigAction(ActionRequest request, ActionResponse response) {
        this.log.info("Basic LTI processConfigAction()");
        boolean success = true;
        PortletPreferences prefs = request.getPreferences();
        String portletHeight = request.getParameter("portletHeight");
        String portletTitle = request.getParameter("portletTitle");
        String providerType = request.getParameter("providerType");
        String launchData = request.getParameter("launchData");
        String key = request.getParameter("key");
        String secret = request.getParameter("secret");
        int newVersion = Integer.valueOf(prefs.getValue("version", "0")) + 1;
        try {
            prefs.setValue("portlet_height", portletHeight);
            prefs.setValue("portlet_title", portletTitle);
            prefs.setValue("provider_type", providerType);
            prefs.setValue("launch_data", launchData);
            prefs.setValue("key", key);
            prefs.setValue("secret", secret);
            prefs.setValue("version", String.valueOf(newVersion));
        }
        catch (ReadOnlyException e) {
            success = false;
            response.setRenderParameter("errorMessage", Messages.getString("error.form.readonly.error"));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        if (success) {
            try {
                prefs.store();
                response.setPortletMode(PortletMode.VIEW);
            }
            catch (ValidatorException e) {
                response.setRenderParameter("errorMessage", e.getMessage());
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                response.setRenderParameter("errorMessage", Messages.getString("error.form.save.error"));
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (PortletModeException e) {
                e.printStackTrace();
            }
        }
    }

    private void processEditAction(ActionRequest request, ActionResponse response) {
        this.log.debug("Basic LTI processEditAction()");
        boolean success = true;
        PortletPreferences prefs = request.getPreferences();
        String portletHeight = request.getParameter("portletHeight");
        String portletTitle = StringEscapeUtils.escapeHtml((String)StringUtils.trim((String)request.getParameter("portletTitle")));
        try {
            prefs.setValue("portlet_height", portletHeight);
            if (StringUtils.isNotBlank((String)portletTitle)) {
                prefs.setValue("portlet_title", portletTitle);
            }
        }
        catch (ReadOnlyException e) {
            success = false;
            response.setRenderParameter("errorMessage", Messages.getString("error.form.readonly.error"));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        if (success) {
            try {
                prefs.store();
                response.setPortletMode(PortletMode.VIEW);
            }
            catch (ValidatorException e) {
                response.setRenderParameter("errorMessage", e.getMessage());
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                response.setRenderParameter("errorMessage", Messages.getString("error.form.save.error"));
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (PortletModeException e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> getUserInfo(RenderRequest request) {
        return (Map)request.getAttribute("javax.portlet.userinfo");
    }

    private String getPortletNamespace(RenderResponse response) {
        return response.getNamespace();
    }

    private String getAdapterClassName(RenderRequest request) {
        return this.adapterClasses.get(this.getConfiguredProviderType(request));
    }

    private Map<String, String> setupLaunchData(RenderRequest request, RenderResponse response) {
        String cacheKey;
        Element element;
        Map<Object, Object> params = new HashMap();
        String key = this.getBasicLTIKey(request);
        String secret = this.getBasicLTISecret(request);
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)secret)) {
            this.log.error("Basic LTI key/secret was blank. Please configure this portlet.");
            this.doError("error.no.basiclti.config", "error.heading.general", request, response);
            return null;
        }
        int prefVersion = this.getPreferenceVersion(request);
        PortletSession session = request.getPortletSession();
        Integer cachedVersion = (Integer)session.getAttribute("version");
        this.log.info("preference version: " + prefVersion + ", cached version: " + cachedVersion);
        if (cachedVersion == null || prefVersion > cachedVersion) {
            this.log.info("Cache is dirty");
            this.evictFromCache(this.getPortletNamespace(response));
        }
        if ((element = this.cache.get((Serializable)((Object)(cacheKey = this.getPortletNamespace(response))))) != null) {
            this.log.info("Fetching data from cache for: " + cacheKey);
            params = (Map)element.getObjectValue();
        } else {
            String rawLaunchData = this.getConfiguredLaunchData(request);
            params = CollectionsSupport.splitStringToMap(rawLaunchData, ";;", "=", true);
            String adapterClassName = this.getAdapterClassName(request);
            String providerType = this.getConfiguredProviderType(request);
            if (this.log.isDebugEnabled()) {
                this.log.info("Adapter: " + adapterClassName);
                this.log.info("ProviderType: " + providerType);
            }
            Map<String, String> userInfo = this.getUserInfo(request);
            if (this.log.isDebugEnabled()) {
                this.log.debug("userInfo parameter map");
                CollectionsSupport.printMap(userInfo);
            }
            params.put("user_id", userInfo.get(this.attributeMappingForUsername));
            params.put("lis_person_name_given", userInfo.get(this.attributeMappingForFirstName));
            params.put("lis_person_name_family", userInfo.get(this.attributeMappingForLastName));
            params.put("lis_person_name_full", userInfo.get(this.attributeMappingForDisplayName));
            params.put("lis_person_contact_email_primary", userInfo.get(this.attributeMappingForEmail));
            params.put("resource_link_id", this.getPortletNamespace(response));
            params.put("tool_consumer_instance_guid", key);
            BasicLTIAdapterFactory factory = new BasicLTIAdapterFactory();
            IBasicLTIAdapter adapter = factory.newAdapter(this.getAdapterClassName(request));
            params = adapter.processLaunchData(params);
            this.log.info("Adding data to cache for: " + cacheKey);
            this.cache.put(new Element((Object)cacheKey, params));
            if (prefVersion > -1) {
                this.log.info("Adding version to PortletSession: " + prefVersion);
                session.setAttribute("version", (Object)prefVersion);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parameter map before OAuth signing");
            CollectionsSupport.printMap(params);
        }
        params = OAuthSupport.signProperties((String)params.get("endpoint_url"), params, "POST", key, secret);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parameter map after OAuth signing");
            CollectionsSupport.printMap(params);
        }
        return params;
    }

    private String getConfiguredProviderType(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("provider_type", "standard");
    }

    private String getConfiguredPortletTitle(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("portlet_title", "Basic LTI Portlet");
    }

    private int getConfiguredPortletHeight(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return Integer.parseInt(pref.getValue("portlet_height", String.valueOf(600)));
    }

    private String getConfiguredLaunchData(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("launch_data", "");
    }

    private String getBasicLTIKey(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("key", "");
    }

    private String getBasicLTISecret(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("secret", "");
    }

    private int getPreferenceVersion(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return Integer.parseInt(pref.getValue("version", "-1"));
    }

    protected String getTitle(RenderRequest request) {
        return this.getConfiguredPortletTitle(request);
    }

    private void evictFromCache(String cacheKey) {
        this.cache.remove((Serializable)((Object)cacheKey));
        this.log.info("Evicted data in cache for key: " + cacheKey);
    }

    private Map<String, String> initAdapters(PortletConfig config) {
        HashMap<String, String> m = new HashMap<String, String>();
        String ADAPTER_CLASS_PREFIX = "adapter-class-";
        ArrayList<String> paramNames = Collections.list(config.getInitParameterNames());
        for (String paramName : paramNames) {
            if (!StringUtils.startsWith((String)paramName, (String)ADAPTER_CLASS_PREFIX)) continue;
            String adapterName = StringUtils.removeStart((String)paramName, (String)ADAPTER_CLASS_PREFIX);
            String adapterClass = config.getInitParameter(paramName);
            m.put(adapterName, adapterClass);
            this.log.info("Registered adapter: " + adapterName + " with class: " + adapterClass);
        }
        this.log.info("Autowired: " + m.size() + " adapters");
        return m;
    }

    private void doError(String messageKey, String headingKey, RenderRequest request, RenderResponse response) {
        request.setAttribute("errorMessage", (Object)Messages.getString(messageKey));
        if (StringUtils.isNotBlank((String)headingKey)) {
            request.setAttribute("errorHeading", (Object)Messages.getString(headingKey));
        } else {
            request.setAttribute("errorHeading", (Object)Messages.getString("error.heading.general"));
        }
        try {
            this.dispatch(request, response, this.errorUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void dispatch(RenderRequest request, RenderResponse response, String path) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(path);
        dispatcher.include(request, response);
    }

    public void destroy() {
        this.log.info("destroy()");
        this.cacheManager.shutdown();
    }
}

