/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service;

import java.io.Serializable;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.jasig.portlet.blackboardvcportlet.data.RecordingMode;
import org.jasig.portlet.blackboardvcportlet.data.ServerConfiguration;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.FutureWithYearLimit;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.QuarterHourCheck;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.SessionEndTimeRangeCheck;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.SessionNameCheck;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.SessionStartIsBeforeEndTimeCheck;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;

@SessionStartIsBeforeEndTimeCheck
@SessionEndTimeRangeCheck
public class SessionForm
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean newSession;
    private boolean needToSendInitialEmail;
    private long sessionId;
    @SessionNameCheck
    private String sessionName;
    @NotNull
    private int boundaryTime;
    private int maxTalkers;
    private int maxCameras;
    private boolean mustBeSupervised;
    private boolean permissionsOn;
    private boolean raiseHandOnEnter;
    private RecordingMode recordingMode;
    private boolean hideParticipantNames;
    private boolean allowInSessionInvites;
    private DateMidnight startDate;
    private LocalTime startHourMinute;
    private LocalTime endHourMinute;
    @Min(value=0L)
    @Max(value=23L)
    private int startHour;
    @QuarterHourCheck
    private int startMinute;
    private DateMidnight endDate;
    @Min(value=0L)
    @Max(value=23L)
    private int endHour;
    @QuarterHourCheck
    private int endMinute;

    public SessionForm() {
    }

    public SessionForm(ServerConfiguration serverConfiguration) {
        this.newSession = true;
        this.needToSendInitialEmail = true;
        DateTime startTime = DateTime.now().plusHours(1).hourOfDay().roundFloorCopy();
        this.setStartTime(startTime);
        this.setEndTime(startTime.plusHours(1));
        this.boundaryTime = serverConfiguration.getBoundaryTime();
        this.maxCameras = serverConfiguration.getMaxAvailableCameras();
        this.maxTalkers = serverConfiguration.getMaxAvailableTalkers();
        this.raiseHandOnEnter = serverConfiguration.isRaiseHandOnEnter();
    }

    public SessionForm(Session session) {
        this.newSession = false;
        this.needToSendInitialEmail = false;
        this.sessionId = session.getSessionId();
        this.sessionName = session.getSessionName();
        this.setStartTime(session.getStartTime());
        this.setEndTime(session.getEndTime());
        this.boundaryTime = session.getBoundaryTime();
        this.maxTalkers = session.getMaxTalkers();
        this.maxCameras = session.getMaxCameras();
        this.mustBeSupervised = session.isMustBeSupervised();
        this.permissionsOn = session.isPermissionsOn();
        this.raiseHandOnEnter = session.isRaiseHandOnEnter();
        this.recordingMode = session.getRecordingMode();
        this.hideParticipantNames = session.isHideParticipantNames();
        this.allowInSessionInvites = session.isAllowInSessionInvites();
    }

    public boolean isNeedToSendInitialEmail() {
        return this.needToSendInitialEmail;
    }

    public void setNeedToSendInitialEmail(boolean needToSendInitialEmail) {
        this.needToSendInitialEmail = needToSendInitialEmail;
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public void setNewSession(boolean newSession) {
        this.newSession = newSession;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    @Future
    @FutureWithYearLimit
    public DateTime getStartTime() {
        return this.startDate.toDateTime().withHourOfDay(this.startHourMinute.getHourOfDay()).withMinuteOfHour(this.startHourMinute.getMinuteOfHour());
    }

    public void setStartTime(DateTime startTime) {
        this.startDate = startTime.toDateMidnight();
        this.startHour = startTime.getHourOfDay();
        this.startMinute = startTime.getMinuteOfHour();
        this.startHourMinute = new LocalTime((Object)startTime);
    }

    @Future
    public DateTime getEndTime() {
        return this.endDate.toDateTime().withHourOfDay(this.endHourMinute.getHourOfDay()).withMinuteOfHour(this.endHourMinute.getMinuteOfHour());
    }

    public void setEndTime(DateTime endTime) {
        this.endDate = endTime.toDateMidnight();
        this.endHour = endTime.getHourOfDay();
        this.endMinute = endTime.getMinuteOfHour();
        this.endHourMinute = new LocalTime((Object)endTime);
    }

    public int getBoundaryTime() {
        return this.boundaryTime;
    }

    public void setBoundaryTime(int boundaryTime) {
        this.boundaryTime = boundaryTime;
    }

    public int getMaxTalkers() {
        return this.maxTalkers;
    }

    public void setMaxTalkers(int maxTalkers) {
        this.maxTalkers = maxTalkers;
    }

    public int getMaxCameras() {
        return this.maxCameras;
    }

    public void setMaxCameras(int maxCameras) {
        this.maxCameras = maxCameras;
    }

    public boolean isMustBeSupervised() {
        return this.mustBeSupervised;
    }

    public void setMustBeSupervised(boolean mustBeSupervised) {
        this.mustBeSupervised = mustBeSupervised;
    }

    public boolean isPermissionsOn() {
        return this.permissionsOn;
    }

    public void setPermissionsOn(boolean permissionsOn) {
        this.permissionsOn = permissionsOn;
    }

    public boolean isRaiseHandOnEnter() {
        return this.raiseHandOnEnter;
    }

    public void setRaiseHandOnEnter(boolean raiseHandOnEnter) {
        this.raiseHandOnEnter = raiseHandOnEnter;
    }

    public RecordingMode getRecordingMode() {
        return this.recordingMode;
    }

    public void setRecordingMode(RecordingMode recordingMode) {
        this.recordingMode = recordingMode;
    }

    public boolean isHideParticipantNames() {
        return this.hideParticipantNames;
    }

    public void setHideParticipantNames(boolean hideParticipantNames) {
        this.hideParticipantNames = hideParticipantNames;
    }

    public boolean isAllowInSessionInvites() {
        return this.allowInSessionInvites;
    }

    public void setAllowInSessionInvites(boolean allowInSessionInvites) {
        this.allowInSessionInvites = allowInSessionInvites;
    }

    public DateMidnight getStartDate() {
        return this.startDate;
    }

    public void setStartDate(DateMidnight startDate) {
        this.startDate = startDate;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public void setStartHour(int startHour) {
        this.startHour = startHour;
    }

    public int getStartMinute() {
        return this.startMinute;
    }

    public void setStartMinute(int startMinute) {
        this.startMinute = startMinute;
    }

    public DateMidnight getEndDate() {
        return this.endDate;
    }

    public void setEndDate(DateMidnight endDate) {
        this.endDate = endDate;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public void setEndHour(int endHour) {
        this.endHour = endHour;
    }

    public int getEndMinute() {
        return this.endMinute;
    }

    public void setEndMinute(int endMinute) {
        this.endMinute = endMinute;
    }

    public void setStartHourMinute(LocalTime startHourMinute) {
        this.startHourMinute = startHourMinute;
    }

    public LocalTime getStartHourMinute() {
        return this.startHourMinute;
    }

    public void setEndHourMinute(LocalTime endHourMinute) {
        this.endHourMinute = endHourMinute;
    }

    public LocalTime getEndHourMinute() {
        return this.endHourMinute;
    }

    public String toString() {
        return "FullSessionForm [newSession=" + this.newSession + ", sessionId=" + this.sessionId + ", sessionName=" + this.sessionName + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", boundaryTime=" + this.boundaryTime + ", maxTalkers=" + this.maxTalkers + ", maxCameras=" + this.maxCameras + ", mustBeSupervised=" + this.mustBeSupervised + ", permissionsOn=" + this.permissionsOn + ", raiseHandOnEnter=" + this.raiseHandOnEnter + ", recordingMode=" + (Object)((Object)this.recordingMode) + ", hideParticipantNames=" + this.hideParticipantNames + ", allowInSessionInvites=" + this.allowInSessionInvites + "]";
    }
}

