/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.validations.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.PhoneNumber;

public class PhoneNumberValidator
implements ConstraintValidator<PhoneNumber, String> {
    private static Pattern phonePattern;

    public void initialize(PhoneNumber constraintAnnotation) {
    }

    public boolean isValid(String testValue, ConstraintValidatorContext context) {
        if (StringUtils.isNotEmpty((String)testValue)) {
            Matcher matcher = phonePattern.matcher(testValue);
            return matcher.matches();
        }
        return true;
    }

    static {
        StringBuilder patternSB = new StringBuilder();
        patternSB.append("(1-\\d{3}-\\d{3}-\\d{4})");
        patternSB.append("|(1 \\d{3} \\d{3} \\d{4})");
        patternSB.append("|(1 \\(\\d{3}\\) \\d{3} \\d{4})");
        patternSB.append("|(1 \\(\\d{3}\\) \\d{3}-\\d{4})");
        patternSB.append("|(\\d{3}-\\d{3}-\\d{4})");
        patternSB.append("|(\\d{3} \\d{3} \\d{4})");
        patternSB.append("|(\\(\\d{3}\\) \\d{3}-\\d{4})");
        patternSB.append("|(\\d{3}\\.\\d{3}\\.\\d{4})");
        phonePattern = Pattern.compile(patternSB.toString());
    }
}

