/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.validations.validators;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.jasig.portlet.blackboardvcportlet.service.SessionForm;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.SessionEndTimeRangeCheck;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionEndTimeRangeCheckValidator
implements ConstraintValidator<SessionEndTimeRangeCheck, SessionForm> {
    private static Logger logger = LoggerFactory.getLogger(SessionEndTimeRangeCheckValidator.class);

    public void initialize(SessionEndTimeRangeCheck constraintAnnotation) {
    }

    public boolean isValid(SessionForm value, ConstraintValidatorContext context) {
        logger.info("isValid() with startTime = {} and value = {}", (Object)value.getStartTime(), (Object)value.getEndTime());
        DateTime startTime = value.getStartTime();
        DateTime endTime = value.getEndTime();
        long max = startTime.plusYears(1).getMillis();
        if (endTime.isBefore(max)) {
            logger.info("End DateTime is within range, so returning true.");
            return true;
        }
        logger.info("End DateTime is NOT within range, so returning false.");
        return false;
    }
}

