/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.validations.validators;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.blackboardvcportlet.validations.annotations.SessionNameCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionNameCheckValidator
implements ConstraintValidator<SessionNameCheck, String> {
    private static final Logger logger = LoggerFactory.getLogger(SessionNameCheckValidator.class);

    public void initialize(SessionNameCheck constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        logger.debug("isValid() called with value = {}", (Object)value);
        if (StringUtils.isEmpty((String)value)) {
            logger.debug("Null, so returning false.");
            return false;
        }
        if (value.length() > 255) {
            logger.debug("The string is longer than 255 characters, returning false.");
            return false;
        }
        if (value.contains("<") || value.contains("&") || value.contains("#") || value.contains("%")) {
            logger.debug("Illegal character found, so returning false.");
            return false;
        }
        logger.debug("Passed all the tests, returning true.");
        return true;
    }
}

