/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.impl;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.blackboardvcportlet.data.BasicUser;
import org.jasig.portlet.blackboardvcportlet.data.BasicUserImpl;
import org.jasig.portlet.blackboardvcportlet.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.OrFilter;

public class LdapUserServiceImpl
implements UserService {
    private static final Pattern NAME_SPLIT = Pattern.compile("\\s+");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BasicUserAttributeMapper basicUserAttributeMapper = new BasicUserAttributeMapper();
    private LdapOperations ldapOperations;
    private String uniqueIdAttributeName = "uid";
    private String displayNameAttributeName = "cn";
    private String firstNameAttributeName = "givenName";
    private String lastNameAttributeName = "sn";
    private String mailAttributeName = "wisceduallemails";

    public void setUniqueIdAttributeName(String uniqueIdAttributeName) {
        this.uniqueIdAttributeName = uniqueIdAttributeName;
    }

    public void setDisplayNameAttributeName(String displayNameAttributeName) {
        this.displayNameAttributeName = displayNameAttributeName;
    }

    public void setFirstNameAttributeName(String firstNameAttributeName) {
        this.firstNameAttributeName = firstNameAttributeName;
    }

    public void setLastNameAttributeName(String lastNameAttributeName) {
        this.lastNameAttributeName = lastNameAttributeName;
    }

    public void setMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
    }

    @Autowired
    public void setLdapOperations(LdapOperations ldapOperations) {
        this.ldapOperations = ldapOperations;
    }

    public BasicUser findUser(String uniqueId) {
        AndFilter andFilter = this.createBaseFilter();
        andFilter.and((Filter)new EqualsFilter(this.uniqueIdAttributeName, uniqueId));
        String searchFilter = andFilter.encode();
        List results = this.ldapOperations.search("", searchFilter, (AttributesMapper)this.basicUserAttributeMapper);
        return (BasicUser)DataAccessUtils.uniqueResult((Collection)results);
    }

    public Set<BasicUser> searchForUserByName(String name) {
        List<String> nameParts = this.getNameParts(name);
        if (nameParts.isEmpty()) {
            return Collections.emptySet();
        }
        AndFilter andFilter = this.createBaseFilter();
        OrFilter orFilter = new OrFilter();
        String namePartZero = nameParts.get(0);
        if (nameParts.size() == 1) {
            orFilter.or((Filter)new LikeFilter(this.firstNameAttributeName, namePartZero + "*"));
            orFilter.or((Filter)new LikeFilter(this.lastNameAttributeName, namePartZero + "*"));
            orFilter.or((Filter)new LikeFilter(this.displayNameAttributeName, namePartZero + "*"));
        } else {
            AndFilter firstLastFilter = new AndFilter();
            firstLastFilter.and((Filter)new LikeFilter(this.firstNameAttributeName, namePartZero + "*"));
            firstLastFilter.and((Filter)new LikeFilter(this.lastNameAttributeName, nameParts.get(nameParts.size() - 1) + "*"));
            orFilter.or((Filter)firstLastFilter);
            String displayNameSearch = NAME_SPLIT.matcher(name.trim()).replaceAll("*") + "*";
            orFilter.or((Filter)new LikeFilter(this.displayNameAttributeName, displayNameSearch));
        }
        andFilter.and((Filter)orFilter);
        String searchFilter = andFilter.encode();
        List results = this.ldapOperations.search("", searchFilter, (AttributesMapper)this.basicUserAttributeMapper);
        return Collections.unmodifiableSet(new LinkedHashSet(results));
    }

    public Set<BasicUser> searchForUserByEmail(String email) {
        if ((email = StringUtils.trimToNull((String)email)) == null) {
            return Collections.emptySet();
        }
        AndFilter andFilter = this.createBaseFilter();
        andFilter.and((Filter)new LikeFilter(this.mailAttributeName, email + "*"));
        String searchFilter = andFilter.encode();
        List results = this.ldapOperations.search("", searchFilter, (AttributesMapper)this.basicUserAttributeMapper);
        return Collections.unmodifiableSet(new LinkedHashSet(results));
    }

    protected AndFilter createBaseFilter() {
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter("objectclass", "person"));
        return andFilter;
    }

    protected List<String> getNameParts(String name) {
        String[] nameParts = NAME_SPLIT.split(name);
        ArrayList<String> usefulNameParts = new ArrayList<String>(nameParts.length);
        for (String namePart : nameParts) {
            if ((namePart = StringUtils.trimToNull((String)namePart)) == null) continue;
            usefulNameParts.add(namePart);
        }
        return usefulNameParts;
    }

    private class BasicUserAttributeMapper
    implements AttributesMapper {
        private BasicUserAttributeMapper() {
        }

        public Object mapFromAttributes(Attributes attributes) throws NamingException {
            String uniqueId = this.getAttribute(LdapUserServiceImpl.this.uniqueIdAttributeName, attributes);
            if (uniqueId == null) {
                throw new IncorrectResultSizeDataAccessException("'" + LdapUserServiceImpl.this.uniqueIdAttributeName + "' is a required attribute", 1, 0);
            }
            String primaryEmail = null;
            ImmutableSet.Builder additionalEmailsBuilder = ImmutableSet.builder();
            Attribute emailAddressAttr = attributes.get(LdapUserServiceImpl.this.mailAttributeName);
            if (emailAddressAttr != null) {
                NamingEnumeration<?> allEmailsEnum = emailAddressAttr.getAll();
                while (allEmailsEnum.hasMore()) {
                    Object email = allEmailsEnum.next();
                    if (email == null) continue;
                    String emailStr = email.toString();
                    if (primaryEmail == null) {
                        primaryEmail = emailStr;
                        continue;
                    }
                    additionalEmailsBuilder.add((Object)emailStr);
                }
            }
            String displayName = this.getAttribute(LdapUserServiceImpl.this.displayNameAttributeName, attributes);
            return new BasicUserImpl(uniqueId, primaryEmail, displayName, (Set)additionalEmailsBuilder.build());
        }

        private String getAttribute(String attributeName, Attributes attributes) throws NamingException {
            Attribute attrValue = attributes.get(attributeName);
            if (attrValue == null) {
                return null;
            }
            Object value = attrValue.get();
            return value.toString();
        }
    }
}

