/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache;

import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.apache.commons.lang.StringUtils;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.AbstractEhcacheRegionFactory;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBeanEhCacheRegionFactory
extends AbstractEhcacheRegionFactory {
    private static final long serialVersionUID = 1L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String CACHE_MANAGER_NAME = "org.jasig.portal.cache.CacheManagerName";

    public void start(Settings settings, Properties properties) throws CacheException {
        this.settings = settings;
        try {
            String cacheManagerBeanName = null;
            if (properties != null) {
                cacheManagerBeanName = StringUtils.trimToNull((String)properties.getProperty(CACHE_MANAGER_NAME));
            }
            if (cacheManagerBeanName == null) {
                throw new IllegalArgumentException("The 'org.jasig.portal.cache.CacheManagerName' property must be set");
            }
            this.logger.debug("Getting CacheManager bean named {}", (Object)cacheManagerBeanName);
            this.manager = CacheManager.getCacheManager((String)cacheManagerBeanName);
            this.mbeanRegistrationHelper.registerMBean(this.manager, properties);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void stop() {
        this.manager = null;
    }
}

