/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.jpa;

import com.google.common.base.Function;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public abstract class BaseJpaDao
implements InitializingBean,
ApplicationContextAware {
    public static final String PERSISTENCE_UNIT_NAME = "BlackboardCollaborateDb";
    private static final String QUERY_SUFFIX = ".Query";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;
    private EntityManager entityManager;
    private TransactionOperations transactionOperations;

    @PersistenceContext(unitName="BlackboardCollaborateDb")
    public final void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Autowired
    public final void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected TransactionOperations getTransactionOperations() {
        return this.transactionOperations;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected final <T> ParameterExpression<T> createParameterExpression(Class<T> paramClass) {
        EntityManagerFactory entityManagerFactory = this.entityManager.getEntityManagerFactory();
        CriteriaBuilder criteriaBuilder = entityManagerFactory.getCriteriaBuilder();
        return criteriaBuilder.parameter(paramClass);
    }

    protected final <T> ParameterExpression<T> createParameterExpression(Class<T> paramClass, String name) {
        EntityManagerFactory entityManagerFactory = this.entityManager.getEntityManagerFactory();
        CriteriaBuilder criteriaBuilder = entityManagerFactory.getCriteriaBuilder();
        return criteriaBuilder.parameter(paramClass, name);
    }

    protected final <T> CriteriaQuery<T> createCriteriaQuery(Function<CriteriaBuilder, CriteriaQuery<T>> builder) {
        EntityManagerFactory entityManagerFactory = this.entityManager.getEntityManagerFactory();
        CriteriaBuilder criteriaBuilder = entityManagerFactory.getCriteriaBuilder();
        final CriteriaQuery criteriaQuery = (CriteriaQuery)builder.apply((Object)criteriaBuilder);
        this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                BaseJpaDao.this.entityManager.createQuery(criteriaQuery);
            }
        });
        return criteriaQuery;
    }

    protected final <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.entityManager.createQuery(criteriaQuery);
    }

    protected final <T> TypedQuery<T> createCachedQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery query = this.entityManager.createQuery(criteriaQuery);
        String cacheRegion = this.getCacheRegionName(criteriaQuery);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
        return query;
    }

    protected final <T> NaturalIdQuery<T> createNaturalIdQuery(Class<T> entityType) {
        Session session;
        try {
            session = (Session)this.entityManager.unwrap(Session.class);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("The DAO Method that calls createNaturalIdQuery must be annotated with @OpenEntityManager or @Transactional", e);
        }
        NaturalIdLoadAccess naturalIdLoadAccess = session.byNaturalId(entityType);
        return new NaturalIdQuery<T>(entityType, naturalIdLoadAccess);
    }

    protected final <T> String getCacheRegionName(CriteriaQuery<T> criteriaQuery) {
        Set roots = criteriaQuery.getRoots();
        Class cacheRegionType = ((Root)roots.iterator().next()).getJavaType();
        String cacheRegion = cacheRegionType.getName() + QUERY_SUFFIX;
        if (roots.size() > 1) {
            this.logger.warn("Query " + criteriaQuery + " in " + this.getClass() + " has " + roots.size() + " roots. The first will be used to generated the cache region name: " + cacheRegion);
        }
        return cacheRegion;
    }

    public static final class NaturalIdQuery<T> {
        private final Class<T> type;
        private final NaturalIdLoadAccess naturalIdLoadAccess;

        public NaturalIdQuery(Class<T> type, NaturalIdLoadAccess naturalIdLoadAccess) {
            this.type = type;
            this.naturalIdLoadAccess = naturalIdLoadAccess;
        }

        public NaturalIdQuery<T> with(LockOptions lockOptions) {
            this.naturalIdLoadAccess.with(lockOptions);
            return this;
        }

        public <P> NaturalIdQuery<T> using(Attribute<? super T, P> attribute, P value) {
            this.naturalIdLoadAccess.using(attribute.getName(), value);
            return this;
        }

        public T getReference() {
            return this.type.cast(this.naturalIdLoadAccess.getReference());
        }

        public T load() {
            return this.type.cast(this.naturalIdLoadAccess.load());
        }
    }
}

