/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.jpa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class CacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectWriter WRITER;
    private final String source;
    private final Serializable[] key;
    @JsonIgnore
    private final int hashCode;

    public static <K extends Serializable, V extends Serializable> CacheKeyBuilder<K, V> builder(String source) {
        return new CacheKeyBuilder(source);
    }

    public static CacheKey build(String source, Serializable ... key) {
        return new CacheKey(source, (Serializable[])key.clone());
    }

    public static CacheKey build(String source, Collection<? extends Serializable> key) {
        return new CacheKey(source, key.toArray(new Serializable[key.size()]));
    }

    public static CacheKey build(String source, Map<? extends Serializable, ? extends Serializable> keyData) {
        Serializable[] key = new Serializable[keyData.size()];
        int mapIndex = 0;
        for (Map.Entry<? extends Serializable, ? extends Serializable> ve : keyData.entrySet()) {
            key[mapIndex++] = new Serializable[]{ve.getKey(), ve.getValue()};
        }
        return new CacheKey(source, key);
    }

    CacheKey(String source, Serializable[] key) {
        this.source = source;
        this.key = key;
        this.hashCode = this.internalHashCode();
    }

    public Serializable getKey() {
        return this.key;
    }

    public String getSource() {
        return this.source;
    }

    private int internalHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.key);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        if (!Arrays.deepEquals(this.key, other.key)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException jsonGenerationException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "CacheKey [source=" + this.source + ", key=" + Arrays.toString(this.key) + "]";
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    public static final class CacheKeyBuilder<K extends Serializable, V extends Serializable> {
        private final String source;
        private ArrayList<Serializable> keyList;
        private Map<Serializable, Serializable> keyMap;

        private CacheKeyBuilder(String source) {
            this.source = source;
        }

        public CacheKeyBuilder<K, V> add(Serializable v) {
            this.checkKeyList();
            this.keyList.add(v);
            return this;
        }

        public CacheKeyBuilder<K, V> addAll(Serializable ... vs) {
            this.checkKeyList();
            for (Serializable v : vs) {
                this.keyList.add(v);
            }
            return this;
        }

        public CacheKeyBuilder<K, V> addAll(Collection<Serializable> vs) {
            this.checkKeyList();
            for (Serializable v : vs) {
                this.keyList.add(v);
            }
            return this;
        }

        public CacheKeyBuilder<K, V> put(K k, V v) {
            this.checkKeyMap();
            this.keyMap.put((Serializable)k, (Serializable)v);
            return this;
        }

        public CacheKeyBuilder<K, V> putAll(Properties p) {
            this.checkKeyMap();
            for (Map.Entry<Object, Object> ve : p.entrySet()) {
                this.keyMap.put((Serializable)((Object)((String)ve.getKey())), (Serializable)((Object)((String)ve.getValue())));
            }
            return this;
        }

        public CacheKeyBuilder<K, V> putAll(Map<? extends K, ? extends V> vm) {
            this.checkKeyMap();
            for (Map.Entry<K, V> ve : vm.entrySet()) {
                this.keyMap.put((Serializable)ve.getKey(), (Serializable)ve.getValue());
            }
            return this;
        }

        public int size() {
            int listLength = this.keyList != null ? this.keyList.size() : 0;
            int mapLength = this.keyMap != null ? this.keyMap.size() : 0;
            return listLength + mapLength;
        }

        public CacheKey build() {
            int listLength = this.keyList != null ? this.keyList.size() : 0;
            int mapLength = this.keyMap != null ? this.keyMap.size() : 0;
            int s = listLength + mapLength;
            Serializable[] key = new Serializable[s];
            if (listLength > 0) {
                this.keyList.toArray(key);
            }
            if (mapLength > 0) {
                int mapIndex = listLength;
                for (Map.Entry<Serializable, Serializable> ve : this.keyMap.entrySet()) {
                    key[mapIndex++] = new Serializable[]{ve.getKey(), ve.getValue()};
                }
            }
            return new CacheKey(this.source, key);
        }

        private void checkKeyList() {
            if (this.keyList == null) {
                this.keyList = new ArrayList();
            }
        }

        private void checkKeyMap() {
            if (this.keyMap == null) {
                this.keyMap = new LinkedHashMap<Serializable, Serializable>();
            }
        }
    }
}

