/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.jpa.OpenEntityManager;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl_;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Multimedia;
import org.jasig.portlet.blackboardvcportlet.data.Presentation;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ConferenceUserDaoImpl
extends BaseJpaDao
implements InternalConferenceUserDao {
    private ParameterExpression<String> emailParameter;
    private CriteriaQuery<ConferenceUserImpl> getUsersByPrimaryEmailQuery;
    private CriteriaQuery<ConferenceUserImpl> getUsersByAnyEmailQuery;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.emailParameter = this.createParameterExpression(String.class, "email");
        this.getUsersByPrimaryEmailQuery = this.createCriteriaQuery(new Function<CriteriaBuilder, CriteriaQuery<ConferenceUserImpl>>(){

            public CriteriaQuery<ConferenceUserImpl> apply(CriteriaBuilder cb) {
                CriteriaQuery criteriaQuery = cb.createQuery(ConferenceUserImpl.class);
                Root definitionRoot = criteriaQuery.from(ConferenceUserImpl.class);
                criteriaQuery.select((Selection)definitionRoot);
                criteriaQuery.where((Expression)cb.equal((Expression)definitionRoot.get(ConferenceUserImpl_.email), (Expression)ConferenceUserDaoImpl.this.emailParameter));
                return criteriaQuery;
            }
        });
        this.getUsersByAnyEmailQuery = this.createCriteriaQuery(new Function<CriteriaBuilder, CriteriaQuery<ConferenceUserImpl>>(){

            public CriteriaQuery<ConferenceUserImpl> apply(CriteriaBuilder cb) {
                CriteriaQuery criteriaQuery = cb.createQuery(ConferenceUserImpl.class);
                Root definitionRoot = criteriaQuery.from(ConferenceUserImpl.class);
                criteriaQuery.select((Selection)definitionRoot);
                criteriaQuery.where((Expression)cb.or((Expression)cb.equal((Expression)definitionRoot.get(ConferenceUserImpl_.email), (Expression)ConferenceUserDaoImpl.this.emailParameter), (Expression)cb.isMember((Expression)ConferenceUserDaoImpl.this.emailParameter, definitionRoot.get(ConferenceUserImpl_.additionalEmails))));
                return criteriaQuery;
            }
        });
    }

    public Set<Session> getOwnedSessionsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        if (userImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(userImpl.getOwnedSessions());
    }

    public Set<Session> getChairedSessionsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        if (userImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(userImpl.getChairedSessions());
    }

    public Set<Session> getNonChairedSessionsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        if (userImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(userImpl.getNonChairedSessions());
    }

    @Override
    @Transactional
    public ConferenceUserImpl createInternalUser(String uniqueId) {
        ConferenceUserImpl user = new ConferenceUserImpl(uniqueId);
        this.getEntityManager().persist((Object)user);
        return user;
    }

    @Transactional
    public ConferenceUserImpl createExternalUser(String displayName, String email) {
        String invitationToken = RandomStringUtils.randomAlphanumeric((int)20);
        ConferenceUserImpl user = new ConferenceUserImpl(email, invitationToken);
        user.setDisplayName(displayName);
        this.getEntityManager().persist((Object)user);
        return user;
    }

    @Override
    @Transactional
    public ConferenceUserImpl createExternalUser(String email) {
        return this.createExternalUser(null, email);
    }

    public Set<Multimedia> getMultimediasForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        return ImmutableSet.copyOf(userImpl.getMultimedias());
    }

    public Set<Presentation> getPresentationsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        return ImmutableSet.copyOf(userImpl.getPresentations());
    }

    @Transactional
    public ConferenceUser updateUser(ConferenceUser user) {
        Validate.notNull((Object)user, (String)"user can not be null");
        this.getEntityManager().persist((Object)user);
        return user;
    }

    @Transactional
    public void deleteUser(ConferenceUser user) {
        Validate.notNull((Object)user, (String)"user can not be null");
        EntityManager entityManager = this.getEntityManager();
        if (!entityManager.contains((Object)user)) {
            user = (ConferenceUser)entityManager.merge((Object)user);
        }
        entityManager.remove((Object)user);
    }

    @Override
    public ConferenceUserImpl getUser(long userId) {
        EntityManager entityManager = this.getEntityManager();
        return (ConferenceUserImpl)entityManager.find(ConferenceUserImpl.class, (Object)userId);
    }

    public Set<ConferenceUser> getUsers(long ... userIds) {
        HashSet<ConferenceUser> users = new HashSet<ConferenceUser>();
        for (long userId : userIds) {
            ConferenceUserImpl user = this.getUser(userId);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    @OpenEntityManager
    public ConferenceUserImpl getUserByUniqueId(String uniqueId) {
        BaseJpaDao.NaturalIdQuery<ConferenceUserImpl> query = this.createNaturalIdQuery(ConferenceUserImpl.class);
        query.using(ConferenceUserImpl_.uniqueId, uniqueId.toUpperCase());
        query.using(ConferenceUserImpl_.external, false);
        return query.load();
    }

    @Override
    @OpenEntityManager
    public ConferenceUserImpl getExternalUserByEmail(String email) {
        BaseJpaDao.NaturalIdQuery<ConferenceUserImpl> query = this.createNaturalIdQuery(ConferenceUserImpl.class);
        query.using(ConferenceUserImpl_.uniqueId, email.toUpperCase());
        query.using(ConferenceUserImpl_.external, true);
        return query.load();
    }

    public Set<ConferenceUser> getUsersByAnyEmail(String email) {
        TypedQuery<ConferenceUserImpl> query = this.createQuery(this.getUsersByAnyEmailQuery);
        query.setParameter(this.emailParameter, (Object)email.toUpperCase());
        List resultList = query.getResultList();
        return new LinkedHashSet<ConferenceUser>(resultList);
    }

    public Set<ConferenceUser> getUsersByPrimaryEmail(String email) {
        TypedQuery<ConferenceUserImpl> query = this.createQuery(this.getUsersByPrimaryEmailQuery);
        query.setParameter(this.emailParameter, (Object)email.toUpperCase());
        List resultList = query.getResultList();
        return new LinkedHashSet<ConferenceUser>(resultList);
    }
}

