/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.jasig.portlet.blackboardvcportlet.dao.impl.MultimediaImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.PresentationImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.UserSessionUrlImpl;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.UserSessionUrl;
import org.springframework.util.Assert;

@Entity
@Table(name="VC2_USER")
@SequenceGenerator(name="VC2_USER_GEN", sequenceName="VC2_USER_SEQ", allocationSize=10)
@TableGenerator(name="VC2_USER_GEN", pkColumnValue="VC2_USER", allocationSize=10)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ConferenceUserImpl
implements ConferenceUser {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="VC2_USER_GEN")
    @Column(name="USER_ID")
    private final long userId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="UNIQUE_ID", length=500, nullable=false)
    private final String uniqueId;
    @NaturalId
    @Column(name="IS_EXTERNAL", nullable=false)
    private final boolean external;
    @Index(name="VC2_IDX__USER_INVITE")
    @Column(name="INVITE_KEY", length=500)
    private final String invitationKey;
    @Column(name="DISPLAY_NAME", length=500)
    private String displayName;
    @Index(name="VC2_IDX__USER_EMAIL")
    @Column(name="EMAIL", length=500)
    private String email;
    @ElementCollection(fetch=FetchType.EAGER, targetClass=String.class)
    @JoinTable(name="VC2_USER_EMAILS", joinColumns={@JoinColumn(name="USER_ID")})
    @Column(name="EMAIL", length=600)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Set<String> additionalEmails = new HashSet<String>(0);
    @OneToMany(targetEntity=MultimediaImpl.class, fetch=FetchType.LAZY, mappedBy="creator")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<MultimediaImpl> multimedias = new HashSet<MultimediaImpl>(0);
    @OneToMany(targetEntity=PresentationImpl.class, fetch=FetchType.LAZY, mappedBy="creator")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<PresentationImpl> presentations = new HashSet<PresentationImpl>(0);
    @OneToMany(targetEntity=SessionImpl.class, fetch=FetchType.LAZY, mappedBy="creator", orphanRemoval=true, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<SessionImpl> ownedSessions = new HashSet<SessionImpl>(0);
    @ManyToMany(targetEntity=SessionImpl.class, fetch=FetchType.LAZY, mappedBy="chairs")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<SessionImpl> chairedSessions = new HashSet<SessionImpl>(0);
    @ManyToMany(targetEntity=SessionImpl.class, fetch=FetchType.LAZY, mappedBy="nonChairs")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<SessionImpl> nonChairedSessions = new HashSet<SessionImpl>(0);
    @OneToMany(mappedBy="user", targetEntity=UserSessionUrlImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private final Set<UserSessionUrl> userUrls = new HashSet<UserSessionUrl>(0);

    private ConferenceUserImpl() {
        this.userId = -1L;
        this.entityVersion = -1L;
        this.uniqueId = null;
        this.email = null;
        this.external = false;
        this.invitationKey = null;
    }

    ConferenceUserImpl(String uniqueId) {
        Assert.notNull((Object)uniqueId, (String)"uniqueId cannot be null");
        this.userId = -1L;
        this.entityVersion = -1L;
        this.uniqueId = uniqueId.toUpperCase();
        this.external = false;
        this.invitationKey = null;
    }

    ConferenceUserImpl(String email, String invitationKey) {
        Assert.notNull((Object)email, (String)"email cannot be null");
        Assert.notNull((Object)invitationKey, (String)"invitationKey cannot be null");
        this.userId = -1L;
        this.entityVersion = -1L;
        this.uniqueId = email.toUpperCase();
        this.setEmail(email);
        this.external = true;
        this.invitationKey = invitationKey;
    }

    @PrePersist
    @PreUpdate
    public void fixEmailCase() {
        LinkedHashSet<String> fixedEmails = new LinkedHashSet<String>();
        Iterator<String> additionalEmailItr = this.additionalEmails.iterator();
        while (additionalEmailItr.hasNext()) {
            String fixedAdditionalEmail;
            String additionalEmail = additionalEmailItr.next();
            if (additionalEmail.equals(fixedAdditionalEmail = additionalEmail.toUpperCase())) continue;
            additionalEmailItr.remove();
            fixedEmails.add(fixedAdditionalEmail);
        }
        this.additionalEmails.addAll(fixedEmails);
    }

    public long getUserId() {
        return this.userId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getBlackboardUniqueId() {
        if (this.isExternal()) {
            return "@EXT@" + this.getUniqueId();
        }
        return this.getUniqueId();
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email != null ? email.toUpperCase() : null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getInvitationKey() {
        return this.invitationKey;
    }

    public Set<String> getAdditionalEmails() {
        return this.additionalEmails;
    }

    Set<SessionImpl> getOwnedSessions() {
        return this.ownedSessions;
    }

    Set<SessionImpl> getChairedSessions() {
        return this.chairedSessions;
    }

    Set<SessionImpl> getNonChairedSessions() {
        return this.nonChairedSessions;
    }

    Set<MultimediaImpl> getMultimedias() {
        return this.multimedias;
    }

    Set<PresentationImpl> getPresentations() {
        return this.presentations;
    }

    public String toString() {
        return "ConferenceUserImpl [userId=" + this.userId + ", uniqueId=" + this.uniqueId + ", displayName=" + this.displayName + ", email=" + this.email + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.external ? 1231 : 1237);
        result = 31 * result + (this.uniqueId == null ? 0 : this.uniqueId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConferenceUserImpl other = (ConferenceUserImpl)obj;
        if (this.external != other.external) {
            return false;
        }
        return !(this.uniqueId == null ? other.uniqueId != null : !this.uniqueId.equals(other.uniqueId));
    }
}

