/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.elluminate.sas.BlackboardMultimediaResponse;
import com.google.common.base.Function;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.Validate;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.jpa.OpenEntityManager;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalMultimediaDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.MultimediaImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.MultimediaImpl_;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Multimedia;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class MultimediaDaoImpl
extends BaseJpaDao
implements InternalMultimediaDao {
    private CriteriaQuery<MultimediaImpl> findAllMultimedia;
    private InternalConferenceUserDao conferenceUserDao;

    @Autowired
    public void setConferenceUserDao(InternalConferenceUserDao conferenceUserDao) {
        this.conferenceUserDao = conferenceUserDao;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.findAllMultimedia = this.createCriteriaQuery(new Function<CriteriaBuilder, CriteriaQuery<MultimediaImpl>>(){

            public CriteriaQuery<MultimediaImpl> apply(CriteriaBuilder cb) {
                CriteriaQuery criteriaQuery = cb.createQuery(MultimediaImpl.class);
                Root definitionRoot = criteriaQuery.from(MultimediaImpl.class);
                criteriaQuery.select((Selection)definitionRoot);
                return criteriaQuery;
            }
        });
    }

    public Set<Multimedia> getAllMultimedia() {
        TypedQuery<MultimediaImpl> query = this.createQuery(this.findAllMultimedia);
        return new LinkedHashSet<Multimedia>(query.getResultList());
    }

    @Override
    public MultimediaImpl getMultimediaById(long multimediaId) {
        return (MultimediaImpl)this.getEntityManager().find(MultimediaImpl.class, (Object)multimediaId);
    }

    @OpenEntityManager
    public MultimediaImpl getMultimediaByBlackboardId(long bbMultimediaId) {
        BaseJpaDao.NaturalIdQuery<MultimediaImpl> query = this.createNaturalIdQuery(MultimediaImpl.class);
        query.using(MultimediaImpl_.bbMultimediaId, bbMultimediaId);
        return query.load();
    }

    @Transactional
    public MultimediaImpl createMultimedia(BlackboardMultimediaResponse multimediaResponse, String filename) {
        String creatorId = multimediaResponse.getCreatorId();
        ConferenceUserImpl creator = this.conferenceUserDao.getUserByUniqueId(creatorId);
        if (creator == null) {
            this.logger.warn("Internal user {} doesn't exist for {}. Creating a bare bones user to compensate", (Object)creatorId, (Object)multimediaResponse);
            creator = this.conferenceUserDao.createInternalUser(creatorId);
        }
        MultimediaImpl blackboardMultimedia = new MultimediaImpl(multimediaResponse.getMultimediaId(), creator);
        this.updateBlackboardMultimedia(multimediaResponse, filename, blackboardMultimedia);
        this.getEntityManager().persist((Object)blackboardMultimedia);
        creator.getMultimedias().add(blackboardMultimedia);
        this.getEntityManager().persist((Object)creator);
        return blackboardMultimedia;
    }

    @Transactional
    public void deleteMultimedia(Multimedia multimedia) {
        Validate.notNull((Object)multimedia, (String)"multimedia can not be null");
        EntityManager entityManager = this.getEntityManager();
        MultimediaImpl multimediaImpl = (MultimediaImpl)entityManager.find(MultimediaImpl.class, (Object)multimedia.getMultimediaId());
        ConferenceUser creator = multimediaImpl.getCreator();
        ConferenceUserImpl creatorImpl = this.conferenceUserDao.getUser(creator.getUserId());
        creatorImpl.getMultimedias().remove(multimediaImpl);
        entityManager.remove((Object)multimediaImpl);
    }

    private void updateBlackboardMultimedia(BlackboardMultimediaResponse multimediaResponse, String filename, MultimediaImpl multimedia) {
        multimedia.setDescription(multimediaResponse.getDescription());
        multimedia.setFilename(filename);
        multimedia.setSize(multimediaResponse.getSize());
    }
}

