/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.elluminate.sas.BlackboardPresentationResponse;
import com.google.common.base.Function;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.Validate;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.jpa.OpenEntityManager;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalPresentationDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.PresentationImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.PresentationImpl_;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Presentation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PresentationDaoImpl
extends BaseJpaDao
implements InternalPresentationDao {
    private CriteriaQuery<PresentationImpl> findAllPresentation;
    private InternalConferenceUserDao conferenceUserDao;

    @Autowired
    public void setConferenceUserDao(InternalConferenceUserDao conferenceUserDao) {
        this.conferenceUserDao = conferenceUserDao;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.findAllPresentation = this.createCriteriaQuery(new Function<CriteriaBuilder, CriteriaQuery<PresentationImpl>>(){

            public CriteriaQuery<PresentationImpl> apply(CriteriaBuilder cb) {
                CriteriaQuery criteriaQuery = cb.createQuery(PresentationImpl.class);
                Root definitionRoot = criteriaQuery.from(PresentationImpl.class);
                criteriaQuery.select((Selection)definitionRoot);
                return criteriaQuery;
            }
        });
    }

    public Set<Presentation> getAllPresentations() {
        TypedQuery<PresentationImpl> query = this.createQuery(this.findAllPresentation);
        return new LinkedHashSet<Presentation>(query.getResultList());
    }

    @Override
    public PresentationImpl getPresentationById(long presentationId) {
        return (PresentationImpl)this.getEntityManager().find(PresentationImpl.class, (Object)presentationId);
    }

    @OpenEntityManager
    public PresentationImpl getPresentationByBlackboardId(long bbPresentationId) {
        BaseJpaDao.NaturalIdQuery<PresentationImpl> query = this.createNaturalIdQuery(PresentationImpl.class);
        query.using(PresentationImpl_.bbPresentationId, bbPresentationId);
        return query.load();
    }

    @Transactional
    public Presentation createPresentation(BlackboardPresentationResponse presentationResponse, String filename) {
        String creatorId = presentationResponse.getCreatorId();
        ConferenceUserImpl creator = this.conferenceUserDao.getUserByUniqueId(creatorId);
        if (creator == null) {
            this.logger.warn("Internal user {} doesn't exist for {}. Creating a bare bones user to compensate", (Object)creatorId, (Object)presentationResponse);
            creator = this.conferenceUserDao.createInternalUser(creatorId);
        }
        PresentationImpl bbPresentation = new PresentationImpl(presentationResponse.getPresentationId(), creator);
        this.updateBlackboardPresentation(presentationResponse, filename, bbPresentation);
        this.getEntityManager().persist((Object)bbPresentation);
        creator.getPresentations().add(bbPresentation);
        this.getEntityManager().persist((Object)creator);
        return bbPresentation;
    }

    @Transactional
    public void deletePresentation(Presentation presentation) {
        Validate.notNull((Object)presentation, (String)"presentation can not be null");
        EntityManager entityManager = this.getEntityManager();
        PresentationImpl presentationImpl = (PresentationImpl)entityManager.find(PresentationImpl.class, (Object)presentation.getPresentationId());
        ConferenceUser creator = presentationImpl.getCreator();
        ConferenceUserImpl creatorImpl = this.conferenceUserDao.getUser(creator.getUserId());
        creatorImpl.getPresentations().remove(presentationImpl);
        entityManager.remove((Object)presentationImpl);
        entityManager.persist((Object)creatorImpl);
    }

    private void updateBlackboardPresentation(BlackboardPresentationResponse presentationResponse, String filename, PresentationImpl presentation) {
        presentation.setDescription(presentationResponse.getDescription());
        presentation.setFilename(filename);
        presentation.setSize(presentationResponse.getSize());
    }
}

