/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.elluminate.sas.BlackboardSessionResponse;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.jpa.OpenEntityManager;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.DaoUtils;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalMultimediaDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalPresentationDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalSessionDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.MultimediaImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.PresentationImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl_;
import org.jasig.portlet.blackboardvcportlet.data.AccessType;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Multimedia;
import org.jasig.portlet.blackboardvcportlet.data.Presentation;
import org.jasig.portlet.blackboardvcportlet.data.RecordingMode;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.SessionRecording;
import org.jasig.portlet.blackboardvcportlet.data.SessionTelephony;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SessionDaoImpl
extends BaseJpaDao
implements InternalSessionDao {
    private static final Pattern USER_LIST_DELIM = Pattern.compile(",");
    private CriteriaQuery<SessionImpl> findAllSessions;
    private InternalConferenceUserDao conferenceUserDao;
    private InternalPresentationDao presentationDao;
    private InternalMultimediaDao multimediaDao;

    @Autowired
    public void setPresentationDao(InternalPresentationDao dao) {
        this.presentationDao = dao;
    }

    @Autowired
    public void setMultimediaDao(InternalMultimediaDao dao) {
        this.multimediaDao = dao;
    }

    @Autowired
    public void setConferenceUserDao(InternalConferenceUserDao conferenceUserDao) {
        this.conferenceUserDao = conferenceUserDao;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.findAllSessions = this.createCriteriaQuery(new Function<CriteriaBuilder, CriteriaQuery<SessionImpl>>(){

            public CriteriaQuery<SessionImpl> apply(CriteriaBuilder cb) {
                CriteriaQuery criteriaQuery = cb.createQuery(SessionImpl.class);
                Root definitionRoot = criteriaQuery.from(SessionImpl.class);
                criteriaQuery.select((Selection)definitionRoot);
                return criteriaQuery;
            }
        });
    }

    public Set<Session> getAllSessions() {
        TypedQuery<SessionImpl> query = this.createQuery(this.findAllSessions);
        return new LinkedHashSet<Session>(query.getResultList());
    }

    public Set<ConferenceUser> getSessionChairs(Session session) {
        if (session == null) {
            return null;
        }
        SessionImpl sessionImpl = this.getSession(session.getSessionId());
        if (sessionImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(sessionImpl.getChairs());
    }

    public Set<Multimedia> getSessionMultimedias(Session session) {
        if (session == null) {
            return null;
        }
        SessionImpl sessionImpl = this.getSession(session.getSessionId());
        if (sessionImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(sessionImpl.getMultimedias());
    }

    public Set<ConferenceUser> getSessionNonChairs(Session session) {
        if (session == null) {
            return null;
        }
        SessionImpl sessionImpl = this.getSession(session.getSessionId());
        if (sessionImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(sessionImpl.getNonChairs());
    }

    public Set<SessionRecording> getSessionRecordings(Session session) {
        if (session == null) {
            return null;
        }
        SessionImpl sessionImpl = this.getSession(session.getSessionId());
        if (sessionImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(sessionImpl.getSessionRecordings());
    }

    public Set<SessionTelephony> getSessionTelephony(Session session) {
        if (session == null) {
            return null;
        }
        SessionImpl sessionImpl = this.getSession(session.getSessionId());
        if (sessionImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf(sessionImpl.getSessionTelephony());
    }

    @Override
    public SessionImpl getSession(long sessionId) {
        EntityManager entityManager = this.getEntityManager();
        return (SessionImpl)entityManager.find(SessionImpl.class, (Object)sessionId);
    }

    @Override
    @OpenEntityManager
    public SessionImpl getSessionByBlackboardId(long bbSessionId) {
        BaseJpaDao.NaturalIdQuery<SessionImpl> query = this.createNaturalIdQuery(SessionImpl.class);
        query.using(SessionImpl_.bbSessionId, bbSessionId);
        return query.load();
    }

    @Transactional
    public SessionImpl createSession(BlackboardSessionResponse sessionResponse, String guestUrl) {
        String creatorId = sessionResponse.getCreatorId();
        ConferenceUserImpl creator = this.conferenceUserDao.getUserByUniqueId(creatorId);
        if (creator == null) {
            this.logger.warn("Internal user for session creator {} doesn't exist for session {}. Creating a bare bones user to compensate", (Object)creatorId, (Object)sessionResponse.getSessionId());
            creator = this.conferenceUserDao.createInternalUser(creatorId);
        }
        SessionImpl session = new SessionImpl(sessionResponse.getSessionId(), creator);
        this.updateBlackboardSession(sessionResponse, session);
        session.setGuestUrl(guestUrl);
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist((Object)session);
        creator.getOwnedSessions().add(session);
        entityManager.persist((Object)creator);
        return session;
    }

    @Transactional
    public SessionImpl updateSession(BlackboardSessionResponse sessionResponse) {
        SessionImpl session = this.getSessionByBlackboardId(sessionResponse.getSessionId());
        if (session == null) {
            throw new IncorrectResultSizeDataAccessException("No BlackboardSession could be found for sessionId " + sessionResponse.getSessionId(), 1);
        }
        this.updateBlackboardSession(sessionResponse, session);
        this.getEntityManager().persist((Object)session);
        return session;
    }

    @Transactional
    public Session addPresentationToSession(Session session, Presentation presentation) {
        SessionImpl blackboardSession = this.getSession(session.getSessionId());
        if (blackboardSession == null) {
            throw new IncorrectResultSizeDataAccessException("No BlackboardSession could be found for sessionId " + session.getSessionId(), 1);
        }
        PresentationImpl bbPresentation = this.presentationDao.getPresentationById(presentation.getPresentationId());
        if (bbPresentation == null) {
            throw new IncorrectResultSizeDataAccessException("No presentation could be found for blackboard presentationId " + presentation.getBbPresentationId(), 1);
        }
        blackboardSession.setPresentation(bbPresentation);
        this.getEntityManager().persist((Object)blackboardSession);
        return blackboardSession;
    }

    @Transactional
    public Session removePresentationFromSession(Session session) {
        SessionImpl blackboardSession = this.getSession(session.getSessionId());
        if (blackboardSession == null) {
            throw new IncorrectResultSizeDataAccessException("No BlackboardSession could be found for sessionId " + session.getSessionId(), 1);
        }
        blackboardSession.setPresentation(null);
        this.getEntityManager().persist((Object)blackboardSession);
        return blackboardSession;
    }

    @Transactional
    public Session addMultimediaToSession(Session session, Multimedia multimedia) {
        SessionImpl blackboardSession = this.getSession(session.getSessionId());
        if (blackboardSession == null) {
            throw new IncorrectResultSizeDataAccessException("No BlackboardSession could be found for sessionId " + session.getSessionId(), 1);
        }
        MultimediaImpl mm = this.multimediaDao.getMultimediaById(multimedia.getMultimediaId());
        if (mm == null) {
            throw new IncorrectResultSizeDataAccessException("No multimedia could be found for blackboard multimediaId " + multimedia.getBbMultimediaId(), 1);
        }
        blackboardSession.getMultimedias().add(mm);
        this.getEntityManager().persist((Object)blackboardSession);
        return blackboardSession;
    }

    @Transactional
    public Session deleteMultimediaFromSession(Session session, Multimedia multimedia) {
        SessionImpl blackboardSession = this.getSession(session.getSessionId());
        if (blackboardSession == null) {
            throw new IncorrectResultSizeDataAccessException("No BlackboardSession could be found for sessionId " + session.getSessionId(), 1);
        }
        MultimediaImpl mm = this.multimediaDao.getMultimediaById(multimedia.getMultimediaId());
        if (mm == null) {
            throw new IncorrectResultSizeDataAccessException("No multimedia could be found for blackboard multimediaId " + multimedia.getBbMultimediaId(), 1);
        }
        blackboardSession.getMultimedias().remove(multimedia);
        this.getEntityManager().persist((Object)blackboardSession);
        return blackboardSession;
    }

    @Transactional
    public void deleteSession(Session session) {
        Validate.notNull((Object)session, (String)"session can not be null");
        SessionImpl sessionImpl = this.getSession(session.getSessionId());
        EntityManager entityManager = this.getEntityManager();
        ConferenceUserImpl creator = sessionImpl.getCreator();
        creator.getOwnedSessions().remove(sessionImpl);
        entityManager.persist((Object)creator);
        for (ConferenceUserImpl user : sessionImpl.getChairs()) {
            user.getChairedSessions().remove(sessionImpl);
            entityManager.persist((Object)user);
        }
        for (ConferenceUserImpl user : sessionImpl.getNonChairs()) {
            user.getNonChairedSessions().remove(sessionImpl);
            entityManager.persist((Object)user);
        }
        entityManager.remove((Object)sessionImpl);
    }

    @Transactional
    public void clearSessionUserList(long sessionId, boolean isChairList) {
        SessionImpl sessionImpl = this.getSession(sessionId);
        EntityManager entityManager = this.getEntityManager();
        if (isChairList) {
            for (ConferenceUserImpl user : sessionImpl.getChairs()) {
                user.getChairedSessions().remove(sessionImpl);
                entityManager.persist((Object)user);
            }
            sessionImpl.getChairs().clear();
            entityManager.persist((Object)sessionImpl);
        } else {
            for (ConferenceUserImpl user : sessionImpl.getNonChairs()) {
                user.getNonChairedSessions().remove(sessionImpl);
                entityManager.persist((Object)user);
            }
            sessionImpl.getNonChairs().clear();
            entityManager.persist((Object)sessionImpl);
        }
    }

    private void updateBlackboardSession(BlackboardSessionResponse sessionResponse, SessionImpl session) {
        session.setAccessType(AccessType.resolveAccessType((long)sessionResponse.getAccessType()));
        session.setAllowInSessionInvites(sessionResponse.isAllowInSessionInvites());
        session.setBoundaryTime(sessionResponse.getBoundaryTime());
        session.setChairNotes(sessionResponse.getChairNotes());
        session.setEndTime(DaoUtils.toDateTime(sessionResponse.getEndTime()));
        session.setHideParticipantNames(sessionResponse.isHideParticipantNames());
        session.setMaxCameras(sessionResponse.getMaxCameras());
        session.setMaxTalkers(sessionResponse.getMaxTalkers());
        session.setMustBeSupervised(sessionResponse.isMustBeSupervised());
        session.setNonChairNotes(sessionResponse.getNonChairNotes());
        session.setOpenChair(sessionResponse.isOpenChair());
        session.setRaiseHandOnEnter(sessionResponse.isRaiseHandOnEnter());
        session.setRecordingMode(RecordingMode.resolveRecordingMode((long)sessionResponse.getRecordingModeType()));
        session.setRecordings(sessionResponse.isRecordings());
        session.setReserveSeats(sessionResponse.getReserveSeats());
        session.setSessionName(sessionResponse.getSessionName());
        session.setStartTime(DaoUtils.toDateTime(sessionResponse.getStartTime()));
        session.setVersionId(sessionResponse.getVersionId());
        session.setPermissionsOn(sessionResponse.isPermissionsOn());
        session.setSecureSignOn(sessionResponse.isSecureSignOn());
        this.updateUserList(sessionResponse, session, UserListType.CHAIR);
        this.updateUserList(sessionResponse, session, UserListType.NON_CHAIR);
    }

    private void updateUserList(BlackboardSessionResponse sessionResponse, SessionImpl blackboardSession, UserListType type) {
        String userList = type.getUserList(sessionResponse);
        String[] userIds = USER_LIST_DELIM.split(userList);
        Set<ConferenceUserImpl> existingUsers = type.getUserSet(blackboardSession);
        HashSet<ConferenceUserImpl> newUsers = new HashSet<ConferenceUserImpl>(userIds.length);
        for (String bbUserId : userIds) {
            ConferenceUserImpl user;
            if ((bbUserId = StringUtils.trimToNull((String)bbUserId)) == null) continue;
            if (bbUserId.startsWith("@EXT@")) {
                String externalUserEmail = bbUserId.substring("@EXT@".length());
                user = this.conferenceUserDao.getExternalUserByEmail(externalUserEmail);
                if (user == null) {
                    user = this.conferenceUserDao.createExternalUser(externalUserEmail);
                }
            } else {
                user = this.conferenceUserDao.getUserByUniqueId(bbUserId);
                if (user == null) {
                    this.logger.warn("Internal user for {} creator {} doesn't exist for session {}. Creating a bare bones user to compensate", new Object[]{bbUserId, type, sessionResponse.getSessionId()});
                    user = this.conferenceUserDao.createInternalUser(bbUserId);
                }
            }
            boolean added = type.associateSession(user, blackboardSession);
            if (added) {
                this.conferenceUserDao.updateUser(user);
            }
            newUsers.add(user);
            existingUsers.add(user);
        }
        Iterator<ConferenceUserImpl> existingUserItr = existingUsers.iterator();
        while (existingUserItr.hasNext()) {
            ConferenceUser existingUser = existingUserItr.next();
            if (newUsers.contains(existingUser)) continue;
            existingUserItr.remove();
            ConferenceUserImpl user = this.conferenceUserDao.getUser(existingUser.getUserId());
            boolean removed = type.unassociateSession(user, blackboardSession);
            if (!removed) continue;
            this.conferenceUserDao.updateUser(user);
        }
    }

    private static enum UserListType {
        CHAIR{

            @Override
            public String getUserList(BlackboardSessionResponse sessionResponse) {
                return sessionResponse.getChairList();
            }

            @Override
            public Set<ConferenceUserImpl> getUserSet(SessionImpl blackboardSession) {
                return blackboardSession.getChairs();
            }

            @Override
            public boolean associateSession(ConferenceUserImpl user, SessionImpl session) {
                session.getChairs().add(user);
                return user.getChairedSessions().add(session);
            }

            @Override
            public boolean unassociateSession(ConferenceUserImpl user, SessionImpl session) {
                session.getChairs().remove(user);
                return user.getChairedSessions().remove(session);
            }
        }
        ,
        NON_CHAIR{

            @Override
            public String getUserList(BlackboardSessionResponse sessionResponse) {
                return sessionResponse.getNonChairList();
            }

            @Override
            public Set<ConferenceUserImpl> getUserSet(SessionImpl blackboardSession) {
                return blackboardSession.getNonChairs();
            }

            @Override
            public boolean associateSession(ConferenceUserImpl user, SessionImpl session) {
                session.getNonChairs().add(user);
                return user.getNonChairedSessions().add(session);
            }

            @Override
            public boolean unassociateSession(ConferenceUserImpl user, SessionImpl session) {
                session.getNonChairs().remove(user);
                return user.getNonChairedSessions().remove(session);
            }
        };


        abstract String getUserList(BlackboardSessionResponse var1);

        abstract Set<ConferenceUserImpl> getUserSet(SessionImpl var1);

        abstract boolean associateSession(ConferenceUserImpl var1, SessionImpl var2);

        abstract boolean unassociateSession(ConferenceUserImpl var1, SessionImpl var2);
    }
}

