/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.MultimediaImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.PresentationImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionRecordingImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionTelephonyImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.UserSessionUrlImpl;
import org.jasig.portlet.blackboardvcportlet.data.AccessType;
import org.jasig.portlet.blackboardvcportlet.data.Presentation;
import org.jasig.portlet.blackboardvcportlet.data.RecordingMode;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.UserSessionUrl;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

@Entity
@Table(name="VC2_SESSION")
@SequenceGenerator(name="VC2_SESSION_GEN", sequenceName="VC2_SESSION_SEQ", allocationSize=10)
@TableGenerator(name="VC2_SESSION_GEN", pkColumnValue="VC2_SESSION", allocationSize=10)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SessionImpl
implements Session {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="VC2_SESSION_GEN")
    @Column(name="SESSION_ID", nullable=false)
    private final long sessionId;
    @Version
    @Column(name="ENTITY_VERSION", nullable=false)
    private final long entityVersion;
    @NaturalId
    @Column(name="BB_SESSION_ID", nullable=false)
    private final long bbSessionId;
    @ManyToOne(targetEntity=ConferenceUserImpl.class, optional=false)
    @JoinColumn(name="CREATOR", nullable=false)
    private final ConferenceUserImpl creator;
    @ManyToOne(targetEntity=PresentationImpl.class)
    @JoinColumn(name="PRESENTATION", nullable=true)
    private PresentationImpl presentation;
    @Column(name="SESSION_NAME", nullable=false, length=1000)
    private String sessionName;
    @Column(name="START_TIME", nullable=false)
    @Type(type="dateTime")
    private DateTime startTime;
    @Column(name="END_TIME", nullable=false)
    @Type(type="dateTime")
    private DateTime endTime;
    @Column(name="BOUNDARY_TIME", nullable=false)
    private int boundaryTime;
    @Column(name="ACCESS_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AccessType accessType;
    @Column(name="RECORDINGS", nullable=false)
    private boolean recordings;
    @Column(name="CHAIR_NOTES", length=4000)
    private String chairNotes;
    @Column(name="NON_CHAIR_NOTES", length=4000)
    private String nonChairNotes;
    private String launchUrl;
    @ManyToMany(targetEntity=ConferenceUserImpl.class, fetch=FetchType.LAZY)
    @JoinTable(name="VC2_SESSION_CHAIRS", joinColumns={@JoinColumn(name="SESSION_ID")}, inverseJoinColumns={@JoinColumn(name="USER_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<ConferenceUserImpl> chairs = new HashSet<ConferenceUserImpl>(0);
    @ManyToMany(targetEntity=ConferenceUserImpl.class, fetch=FetchType.LAZY)
    @JoinTable(name="VC2_SESSION_NONCHAIRS", joinColumns={@JoinColumn(name="SESSION_ID")}, inverseJoinColumns={@JoinColumn(name="USER_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<ConferenceUserImpl> nonChairs = new HashSet<ConferenceUserImpl>(0);
    @ManyToMany(targetEntity=MultimediaImpl.class, fetch=FetchType.LAZY)
    @JoinTable(name="VC2_SESSION_MULTIMEDIA", joinColumns={@JoinColumn(name="SESSION_ID")}, inverseJoinColumns={@JoinColumn(name="MULTIMEDIA_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<MultimediaImpl> multimedias = new HashSet<MultimediaImpl>(0);
    @Column(name="OPEN_CHAIR", nullable=false)
    private boolean openChair;
    @Column(name="MUST_BE_SUPERVISED", nullable=false)
    private boolean mustBeSupervised;
    @Column(name="RECORDING_MODE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private RecordingMode recordingMode;
    @Column(name="MAX_TALKERS", nullable=false)
    private int maxTalkers;
    @Column(name="MAX_CAMERAS", nullable=false)
    private int maxCameras;
    @Column(name="RAISE_HAND_ON_ENTER", nullable=false)
    private boolean raiseHandOnEnter;
    @Column(name="RESERVE_SEATS", nullable=false)
    private int reserveSeats;
    @Column(name="VERSION_ID", nullable=false)
    private long versionId;
    @Column(name="ALLOW_IN_SESSION_INVITES", nullable=false)
    private boolean allowInSessionInvites = true;
    @Column(name="HIDE_PARTICIPANT_NAMES", nullable=false)
    private boolean hideParticipantNames = true;
    @Column(name="PERMISSIONS_ON", nullable=false)
    private boolean permissionsOn = false;
    @Column(name="SECURE_SIGN_ON", nullable=false)
    private boolean secureSignOn = false;
    @Column(name="GUEST_URL", nullable=false, length=4000)
    private String guestUrl;
    @Column(name="LAST_UPDATED", nullable=false)
    @Type(type="dateTime")
    private DateTime lastUpdated;
    @OneToMany(mappedBy="session", targetEntity=SessionRecordingImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<SessionRecordingImpl> sessionRecordings = new HashSet<SessionRecordingImpl>(0);
    @OneToMany(mappedBy="session", targetEntity=SessionTelephonyImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<SessionTelephonyImpl> sessionTelephony = new HashSet<SessionTelephonyImpl>(0);
    @OneToMany(mappedBy="session", targetEntity=UserSessionUrlImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private final Set<UserSessionUrl> userUrls = new HashSet<UserSessionUrl>(0);

    private SessionImpl() {
        this.sessionId = -1L;
        this.entityVersion = -1L;
        this.bbSessionId = -1L;
        this.creator = null;
    }

    SessionImpl(long bbSessionId, ConferenceUserImpl creator) {
        Validate.notNull((Object)creator, (String)"creator cannot be null");
        this.sessionId = -1L;
        this.entityVersion = -1L;
        this.bbSessionId = bbSessionId;
        this.creator = creator;
    }

    @PreUpdate
    @PrePersist
    protected final void onUpdate() {
        this.lastUpdated = DateTime.now();
    }

    public boolean isPermissionsOn() {
        return this.permissionsOn;
    }

    public void setPermissionsOn(boolean permissionsOn) {
        this.permissionsOn = permissionsOn;
    }

    public boolean isSecureSignOn() {
        return this.secureSignOn;
    }

    public void setSecureSignOn(boolean secureSignOn) {
        this.secureSignOn = secureSignOn;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getStartTimeWithBoundaryTime() {
        return this.startTime.minusMinutes(this.boundaryTime);
    }

    public void setStartTime(DateTime startTime) {
        this.startTime = startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime endTime) {
        this.endTime = endTime;
    }

    public int getBoundaryTime() {
        return this.boundaryTime;
    }

    public void setBoundaryTime(int boundaryTime) {
        this.boundaryTime = boundaryTime;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public boolean isRecordings() {
        return this.recordings;
    }

    public void setRecordings(boolean recordings) {
        this.recordings = recordings;
    }

    public String getChairNotes() {
        return this.chairNotes;
    }

    public void setChairNotes(String chairNotes) {
        this.chairNotes = chairNotes;
    }

    public String getNonChairNotes() {
        return this.nonChairNotes;
    }

    public void setNonChairNotes(String nonChairNotes) {
        this.nonChairNotes = nonChairNotes;
    }

    Set<ConferenceUserImpl> getChairs() {
        return this.chairs;
    }

    Set<ConferenceUserImpl> getNonChairs() {
        return this.nonChairs;
    }

    Set<MultimediaImpl> getMultimedias() {
        return this.multimedias;
    }

    Set<SessionRecordingImpl> getSessionRecordings() {
        return this.sessionRecordings;
    }

    Set<SessionTelephonyImpl> getSessionTelephony() {
        return this.sessionTelephony;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public boolean isOpenChair() {
        return this.openChair;
    }

    public void setOpenChair(boolean openChair) {
        this.openChair = openChair;
    }

    public boolean isMustBeSupervised() {
        return this.mustBeSupervised;
    }

    public void setMustBeSupervised(boolean mustBeSupervised) {
        this.mustBeSupervised = mustBeSupervised;
    }

    public RecordingMode getRecordingMode() {
        return this.recordingMode;
    }

    public void setRecordingMode(RecordingMode recordingMode) {
        this.recordingMode = recordingMode;
    }

    public int getMaxTalkers() {
        return this.maxTalkers;
    }

    public void setMaxTalkers(int maxTalkers) {
        this.maxTalkers = maxTalkers;
    }

    public int getMaxCameras() {
        return this.maxCameras;
    }

    public void setMaxCameras(int maxCameras) {
        this.maxCameras = maxCameras;
    }

    public boolean isRaiseHandOnEnter() {
        return this.raiseHandOnEnter;
    }

    public void setRaiseHandOnEnter(boolean raiseHandOnEnter) {
        this.raiseHandOnEnter = raiseHandOnEnter;
    }

    public int getReserveSeats() {
        return this.reserveSeats;
    }

    public void setReserveSeats(int reserveSeats) {
        this.reserveSeats = reserveSeats;
    }

    public long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(long versionId) {
        this.versionId = versionId;
    }

    public boolean isAllowInSessionInvites() {
        return this.allowInSessionInvites;
    }

    public void setAllowInSessionInvites(boolean allowInSessionInvites) {
        this.allowInSessionInvites = allowInSessionInvites;
    }

    public boolean isHideParticipantNames() {
        return this.hideParticipantNames;
    }

    public void setHideParticipantNames(boolean hideParticipantNames) {
        this.hideParticipantNames = hideParticipantNames;
    }

    public String getGuestUrl() {
        return this.guestUrl;
    }

    public void setGuestUrl(String guestUrl) {
        this.guestUrl = guestUrl;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getEntityVersion() {
        return this.entityVersion;
    }

    public long getBbSessionId() {
        return this.bbSessionId;
    }

    public ConferenceUserImpl getCreator() {
        return this.creator;
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    void setPresentation(PresentationImpl value) {
        this.presentation = value;
    }

    public void setLaunchUrl(String launchUrl) {
        this.launchUrl = launchUrl;
    }

    public String getLaunchUrl() {
        return this.launchUrl;
    }

    public String getTimeFancyText(DateTime from, DateTime to) {
        String prefix = "Join in ";
        if (to != null) {
            Duration d = new Duration((ReadableInstant)to, (ReadableInstant)from);
            Period timeUntil = new Period((ReadableInstant)to.toInstant(), (ReadableInstant)from.toInstant(), PeriodType.dayTime());
            long standardDays = d.getStandardDays();
            if (standardDays > 0L) {
                PeriodFormatter daysHours = new PeriodFormatterBuilder().appendDays().appendSuffix(" day", " days").appendSeparator(", and ").appendHours().appendSuffix(" hour", " hours").toFormatter();
                return "Join in " + daysHours.print((ReadablePeriod)timeUntil.normalizedStandard(PeriodType.dayTime()));
            }
            PeriodFormatter dafaultFormatter = new PeriodFormatterBuilder().appendHours().appendSuffix(" hour", " hours").appendSeparator(", and ").appendMinutes().appendSuffix(" minute", " minutes").toFormatter();
            return "Join in " + dafaultFormatter.print((ReadablePeriod)timeUntil.normalizedStandard(PeriodType.dayTime()));
        }
        return null;
    }

    public String getTimeUntilJoin() {
        return this.getTimeFancyText(this.startTime, DateTime.now());
    }

    public String toString() {
        return "BlackboardSessionImpl [sessionId=" + this.sessionId + ", sessionName=" + this.sessionName + ", startTime=" + this.startTime + ", endTime=" + this.endTime + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bbSessionId ^ this.bbSessionId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionImpl other = (SessionImpl)obj;
        return this.bbSessionId == other.bbSessionId;
    }
}

