/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.io.FileUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.data.SessionRecording;
import org.joda.time.DateTime;

@Entity
@Table(name="VC2_RECORDING")
@SequenceGenerator(name="VC2_RECORDING_GEN", sequenceName="VC2_RECORDING_SEQ", allocationSize=10)
@TableGenerator(name="VC2_RECORDING_GEN", pkColumnValue="VC2_RECORDING", allocationSize=10)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SessionRecordingImpl
implements SessionRecording {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="VC2_RECORDING_GEN")
    @Column(name="RECORDING_ID")
    private final long recordingId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="BB_RECORDING_ID", nullable=false)
    private final long bbRecordingId;
    @Column(name="ROOM_START", nullable=false)
    @Type(type="dateTime")
    private DateTime roomStart;
    @Column(name="ROOM_END", nullable=false)
    @Type(type="dateTime")
    private DateTime roomEnd;
    @Column(name="RECORDING_URL", nullable=false, length=2000)
    private String recordingUrl;
    @Column(name="SECURE_SIGN_ON", nullable=false)
    private boolean secureSignOn;
    @Column(name="CREATION_DATE", nullable=false)
    @Type(type="dateTime")
    private DateTime creationDate;
    @Column(name="RECORDING_SIZE", nullable=false)
    private long recordingSize;
    @Column(name="ROOM_NAME", nullable=false, length=1000)
    private String roomName;
    @ManyToOne(targetEntity=SessionImpl.class, optional=false)
    @JoinColumn(name="SESSION_ID", nullable=false)
    private final SessionImpl session;

    private SessionRecordingImpl() {
        this.recordingId = -1L;
        this.entityVersion = -1L;
        this.bbRecordingId = -1L;
        this.session = null;
    }

    SessionRecordingImpl(long bbRecordingId, SessionImpl session) {
        this.recordingId = -1L;
        this.entityVersion = -1L;
        this.bbRecordingId = bbRecordingId;
        this.session = session;
    }

    public long getRecordingId() {
        return this.recordingId;
    }

    public long getBbRecordingId() {
        return this.bbRecordingId;
    }

    public DateTime getRoomStart() {
        return this.roomStart;
    }

    public DateTime getRoomEnd() {
        return this.roomEnd;
    }

    public String getRecordingUrl() {
        return this.recordingUrl;
    }

    public boolean isSecureSignOn() {
        return this.secureSignOn;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public long getRecordingSize() {
        return this.recordingSize;
    }

    public String getDisplayRecordingSize() {
        return FileUtils.byteCountToDisplaySize((long)this.recordingSize);
    }

    public String getRoomName() {
        return this.roomName;
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public void setRoomStart(DateTime roomStart) {
        this.roomStart = roomStart;
    }

    public void setRoomEnd(DateTime roomEnd) {
        this.roomEnd = roomEnd;
    }

    public void setRecordingUrl(String recordingUrl) {
        this.recordingUrl = recordingUrl;
    }

    public void setSecureSignOn(boolean secureSignOn) {
        this.secureSignOn = secureSignOn;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setRecordingSize(long recordingSize) {
        this.recordingSize = recordingSize;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bbRecordingId ^ this.bbRecordingId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionRecordingImpl other = (SessionRecordingImpl)obj;
        return this.bbRecordingId == other.bbRecordingId;
    }

    public String toString() {
        return "SessionRecordingImpl [recordingId=" + this.recordingId + ", entityVersion=" + this.entityVersion + ", bbRecordingId=" + this.bbRecordingId + ", roomStart=" + this.roomStart + ", roomEnd=" + this.roomEnd + ", recordingUrl=" + this.recordingUrl + ", secureSignOn=" + this.secureSignOn + ", creationDate=" + this.creationDate + ", recordingSize=" + this.recordingSize + ", roomName=" + this.roomName + ", sessionId=" + this.session.getBbSessionId() + "]";
    }
}

