/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.elluminate.sas.BlackboardSessionTelephonyResponse;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.portlet.blackboardvcportlet.dao.SessionTelephonyDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalSessionDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionTelephonyImpl;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.SessionTelephony;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SessionTelephonyDaoImpl
extends BaseJpaDao
implements SessionTelephonyDao {
    private InternalSessionDao sessionDao;
    private CriteriaQuery<SessionTelephonyImpl> findAllSessionTelephony;

    @Autowired
    public void setSessionDao(InternalSessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.findAllSessionTelephony = this.createCriteriaQuery(new Function<CriteriaBuilder, CriteriaQuery<SessionTelephonyImpl>>(){

            public CriteriaQuery<SessionTelephonyImpl> apply(CriteriaBuilder cb) {
                CriteriaQuery criteriaQuery = cb.createQuery(SessionTelephonyImpl.class);
                Root definitionRoot = criteriaQuery.from(SessionTelephonyImpl.class);
                criteriaQuery.select((Selection)definitionRoot);
                return criteriaQuery;
            }
        });
    }

    public Set<SessionTelephony> getAllTelephony() {
        TypedQuery<SessionTelephonyImpl> query = this.createCachedQuery(this.findAllSessionTelephony);
        List sessionTelephonyList = query.getResultList();
        return new LinkedHashSet<SessionTelephony>(sessionTelephonyList);
    }

    public SessionTelephonyImpl getSessionTelephony(long telephonyId) {
        return (SessionTelephonyImpl)this.getEntityManager().find(SessionTelephonyImpl.class, (Object)telephonyId);
    }

    @Transactional
    public SessionTelephonyImpl createOrUpdateTelephony(BlackboardSessionTelephonyResponse telephonyResponse) {
        Long bbSessionId = telephonyResponse.getSessionId();
        SessionImpl session = this.sessionDao.getSessionByBlackboardId(bbSessionId);
        if (session == null) {
            throw new IllegalArgumentException("No session with blackboard session id '" + bbSessionId + "' exists, cannot update recording");
        }
        SessionTelephonyImpl telephony = (SessionTelephonyImpl)DataAccessUtils.singleResult(session.getSessionTelephony());
        if (telephony == null) {
            telephony = new SessionTelephonyImpl(session);
            session.getSessionTelephony().add(telephony);
        }
        telephony.setChairPhone(telephonyResponse.getChairPhone());
        telephony.setChairPIN(telephonyResponse.getChairPIN());
        telephony.setNonChairPhone(telephonyResponse.getNonChairPhone());
        telephony.setNonChairPIN(telephonyResponse.getNonChairPIN());
        telephony.setPhone(telephonyResponse.isIsPhone());
        telephony.setSessionPIN(telephonyResponse.getSessionPIN());
        telephony.setSessionSIPPhone(telephonyResponse.getSessionSIPPhone());
        this.getEntityManager().persist((Object)telephony);
        this.getEntityManager().persist((Object)session);
        return telephony;
    }

    @Transactional
    public void updateSessionTelephony(SessionTelephony telephony) {
        this.getEntityManager().persist((Object)telephony);
    }

    @Transactional
    public void deleteTelephony(long sessionId) {
        SessionImpl session = this.sessionDao.getSession(sessionId);
        SessionTelephonyImpl sessionTelephony = (SessionTelephonyImpl)DataAccessUtils.singleResult(session.getSessionTelephony());
        session.getSessionTelephony().remove(sessionTelephony);
        EntityManager entityManager = this.getEntityManager();
        entityManager.remove((Object)sessionTelephony);
        entityManager.persist((Object)session);
    }

    @Transactional
    public SessionTelephony getSessionTelephony(Session session) {
        return (SessionTelephony)DataAccessUtils.singleResult((Collection)this.sessionDao.getSessionTelephony(session));
    }
}

