/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.UserSessionUrl;

@Entity
@Table(name="VC2_USER_SESSION_URL")
@SequenceGenerator(name="VC2_USER_SESSION_URL_GEN", sequenceName="VC2_USER_SESSION_URL_SEQ", allocationSize=10)
@TableGenerator(name="VC2_USER_SESSION_URL_GEN", pkColumnValue="VC2_USER_SESSION_URL", allocationSize=10)
@Immutable
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class UserSessionUrlImpl
implements UserSessionUrl {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="VC2_USER_SESSION_URL_GEN")
    @Column(name="URL_ID")
    private final long urlId;
    @NaturalId
    @ManyToOne(targetEntity=SessionImpl.class, optional=false)
    @JoinColumn(name="SESSION_ID", nullable=false)
    private final Session session;
    @NaturalId
    @ManyToOne(targetEntity=ConferenceUserImpl.class, optional=false)
    @JoinColumn(name="USER_ID", nullable=false)
    private final ConferenceUser user;
    @Column(name="URL", nullable=false)
    private final String url;

    private UserSessionUrlImpl() {
        this.urlId = -1L;
        this.session = null;
        this.user = null;
        this.url = null;
    }

    UserSessionUrlImpl(Session session, ConferenceUser creator, String url) {
        this.urlId = -1L;
        this.session = session;
        this.user = creator;
        this.url = url;
    }

    public long getUrlId() {
        return this.urlId;
    }

    public Session getSession() {
        return this.session;
    }

    public ConferenceUser getUser() {
        return this.user;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserSessionUrlImpl other = (UserSessionUrlImpl)obj;
        if (this.session == null ? other.session != null : !this.session.equals(other.session)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "UserSessionUrlImpl [urlId=" + this.urlId + ", url=" + this.url + ", user=" + this.user + ", session=" + this.session + "]";
    }
}

