/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.ws.impl;

import com.elluminate.sas.BlackboardGetServerConfigurationResponseCollection;
import com.elluminate.sas.BlackboardGetServerQuotasResponseCollection;
import com.elluminate.sas.BlackboardGetServerVersionResponseCollection;
import com.elluminate.sas.BlackboardServerConfigurationResponse;
import com.elluminate.sas.BlackboardServerQuotasResponse;
import com.elluminate.sas.BlackboardServerVersionResponse;
import com.elluminate.sas.BlackboardSetApiCallbackUrl;
import com.elluminate.sas.ObjectFactory;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.blackboardvcportlet.dao.ws.GlobalSettingsWSDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.WSDaoUtils;
import org.jasig.portlet.blackboardvcportlet.service.util.SASWebServiceOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Service;

@Service
public class GlobalSettingsWSDaoImpl
implements GlobalSettingsWSDao {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SASWebServiceOperations sasWebServiceTemplate;
    private String callbackURL;

    @Value(value="${bbc.callbackURL:}")
    public void setCallbackURL(String value) {
        this.callbackURL = StringUtils.trimToNull((String)value);
    }

    @Autowired
    public void setSasWebServiceTemplate(SASWebServiceOperations sasWebServiceTemplate) {
        this.sasWebServiceTemplate = sasWebServiceTemplate;
    }

    public BlackboardServerConfigurationResponse getServerConfiguration() {
        JAXBElement request = new ObjectFactory().createGetServerConfiguration(null);
        BlackboardGetServerConfigurationResponseCollection responseCollection = (BlackboardGetServerConfigurationResponseCollection)this.sasWebServiceTemplate.marshalSendAndReceiveToSAS("http://sas.elluminate.com/GetServerConfiguration", (Object)request);
        List configResult = responseCollection.getServerConfigurationResponses();
        return (BlackboardServerConfigurationResponse)DataAccessUtils.singleResult((Collection)configResult);
    }

    public BlackboardServerQuotasResponse getServerQuota() {
        JAXBElement request = new ObjectFactory().createGetServerQuotas(null);
        BlackboardGetServerQuotasResponseCollection serverQuotasResponseCollection = (BlackboardGetServerQuotasResponseCollection)this.sasWebServiceTemplate.marshalSendAndReceiveToSAS("http://sas.elluminate.com/GetServerQuotas", (Object)request);
        List quotaResult = serverQuotasResponseCollection.getServerQuotasResponses();
        return (BlackboardServerQuotasResponse)DataAccessUtils.singleResult((Collection)quotaResult);
    }

    public BlackboardServerVersionResponse getServerVersions() {
        JAXBElement request = new ObjectFactory().createGetServerVersions(null);
        BlackboardGetServerVersionResponseCollection serverVersionResponseCollection = (BlackboardGetServerVersionResponseCollection)this.sasWebServiceTemplate.marshalSendAndReceiveToSAS("http://sas.elluminate.com/GetServerVersions", (Object)request);
        List versionResult = serverVersionResponseCollection.getServerVersionResponses();
        return (BlackboardServerVersionResponse)DataAccessUtils.singleResult((Collection)versionResult);
    }

    public boolean setApiCallbackUrl(String randomURLToken) {
        if (this.callbackURL == null) {
            this.logger.warn("No bbc.callbackURL property specified. SetApiCallbackUrl will not be called");
            return true;
        }
        BlackboardSetApiCallbackUrl apiCallbackRequest = new ObjectFactory().createBlackboardSetApiCallbackUrl();
        apiCallbackRequest.setApiCallbackUrl(this.callbackURL + (this.callbackURL.charAt(this.callbackURL.length() - 1) == '/' ? "" : Character.valueOf('/')) + randomURLToken);
        if (!WSDaoUtils.isSuccessful((Object)this.sasWebServiceTemplate.marshalSendAndReceiveToSAS("http://sas.elluminate.com/SetApiCallbackUrl", (Object)apiCallbackRequest))) {
            this.logger.warn("Issue sending blackboard api callback URL");
            return false;
        }
        return true;
    }
}

