/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.ws.impl;

import com.elluminate.sas.BlackboardListRepositoryPresentation;
import com.elluminate.sas.BlackboardListSessionContent;
import com.elluminate.sas.BlackboardPresentationResponse;
import com.elluminate.sas.BlackboardPresentationResponseCollection;
import com.elluminate.sas.BlackboardRemoveRepositoryPresentation;
import com.elluminate.sas.BlackboardRemoveSessionPresentation;
import com.elluminate.sas.BlackboardSetSessionPresentation;
import com.elluminate.sas.BlackboardUploadRepositoryContent;
import com.elluminate.sas.ObjectFactory;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import org.jasig.portlet.blackboardvcportlet.dao.ws.PresentationWSDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.WSDaoUtils;
import org.jasig.portlet.blackboardvcportlet.service.util.SASWebServiceOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Service;

@Service
public class PresentationWSDaoImpl
implements PresentationWSDao {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private SASWebServiceOperations sasWebServiceOperations;

    @Autowired
    public void setSasWebServiceOperations(SASWebServiceOperations sasWebServiceOperations) {
        this.sasWebServiceOperations = sasWebServiceOperations;
    }

    public BlackboardPresentationResponse uploadPresentation(long sessionId, String creatorId, String filename, String description, DataHandler data) {
        BlackboardPresentationResponse response = this.uploadPresentation(creatorId, filename, description, data);
        if (!this.linkPresentationToSession(sessionId, response.getPresentationId())) {
            this.logger.error("Error linking presentation (" + response.getPresentationId() + ") to session (" + sessionId + "), however upload was successful.");
        }
        return response;
    }

    public BlackboardPresentationResponse uploadPresentation(String creatorId, String filename, String description, DataHandler data) {
        BlackboardUploadRepositoryContent request = new ObjectFactory().createBlackboardUploadRepositoryContent();
        request.setCreatorId(creatorId);
        request.setDescription(description);
        request.setFilename(filename);
        request.setContent(data);
        JAXBElement createUploadRepositoryPresentation = new ObjectFactory().createUploadRepositoryPresentation(request);
        JAXBElement response = (JAXBElement)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/UploadRepositoryPresentation", (Object)createUploadRepositoryPresentation);
        BlackboardPresentationResponseCollection unwrappedResponse = (BlackboardPresentationResponseCollection)response.getValue();
        return (BlackboardPresentationResponse)DataAccessUtils.singleResult((Collection)unwrappedResponse.getPresentationResponses());
    }

    public boolean linkPresentationToSession(long sessionId, long presentationId) {
        BlackboardSetSessionPresentation request = new ObjectFactory().createBlackboardSetSessionPresentation();
        request.setPresentationId(presentationId);
        request.setSessionId(sessionId);
        if (WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/SetSessionPresentation", (Object)request))) {
            return true;
        }
        this.logger.error("Issue linking the presentation id " + presentationId + " with session " + sessionId);
        return false;
    }

    public List<BlackboardPresentationResponse> getSessionPresentations(long sessionId) {
        BlackboardListSessionContent request = new ObjectFactory().createBlackboardListSessionContent();
        request.setSessionId(sessionId);
        JAXBElement createListSessionPresentation = new ObjectFactory().createListSessionPresentation(request);
        JAXBElement objSessionResponse = (JAXBElement)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListSessionPresentation", (Object)createListSessionPresentation);
        return ((BlackboardPresentationResponseCollection)objSessionResponse.getValue()).getPresentationResponses();
    }

    public List<BlackboardPresentationResponse> getRepositoryPresentations(String creatorId, Long presentationId, String description) {
        BlackboardListRepositoryPresentation request = new ObjectFactory().createBlackboardListRepositoryPresentation();
        if (creatorId == null && presentationId == null && description == null) {
            throw new IllegalStateException("You must specify at least one piece of criteria");
        }
        if (creatorId != null) {
            request.setCreatorId(creatorId);
        }
        if (presentationId != null) {
            request.setPresentationId(presentationId);
        }
        if (description != null) {
            request.setDescription(description);
        }
        JAXBElement response = (JAXBElement)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListRepositoryPresentation", (Object)request);
        BlackboardPresentationResponseCollection objSessionResponse = (BlackboardPresentationResponseCollection)response.getValue();
        return objSessionResponse.getPresentationResponses();
    }

    public boolean deletePresentation(long presentationId) {
        BlackboardRemoveRepositoryPresentation request = new ObjectFactory().createBlackboardRemoveRepositoryPresentation();
        request.setPresentationId(presentationId);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/RemoveRepositoryPresentation", (Object)request));
    }

    public boolean deleteSessionPresenation(long sessionId, long presentationId) {
        BlackboardRemoveSessionPresentation request = new ObjectFactory().createBlackboardRemoveSessionPresentation();
        request.setSessionId(sessionId);
        request.setPresentationId(presentationId);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/RemoveSessionPresentation", (Object)request));
    }
}

