/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.ws.impl;

import com.elluminate.sas.BlackboardBuildRecordingUrl;
import com.elluminate.sas.BlackboardListRecordingLong;
import com.elluminate.sas.BlackboardListRecordingLongResponseCollection;
import com.elluminate.sas.BlackboardListRecordingShort;
import com.elluminate.sas.BlackboardListRecordingShortResponseCollection;
import com.elluminate.sas.BlackboardRecordingLongResponse;
import com.elluminate.sas.BlackboardRecordingShortResponse;
import com.elluminate.sas.BlackboardRemoveRecording;
import com.elluminate.sas.BlackboardSetRecordingSecureSignOn;
import com.elluminate.sas.BlackboardUrlResponse;
import com.elluminate.sas.ObjectFactory;
import java.util.List;
import org.jasig.portlet.blackboardvcportlet.dao.ws.RecordingWSDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.WSDaoUtils;
import org.jasig.portlet.blackboardvcportlet.service.util.SASWebServiceOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordingWSDaoImpl
implements RecordingWSDao {
    private SASWebServiceOperations sasWebServiceOperations;

    @Autowired
    public void setSasWebServiceOperations(SASWebServiceOperations sasWebServiceOperations) {
        this.sasWebServiceOperations = sasWebServiceOperations;
    }

    public List<BlackboardRecordingLongResponse> getRecordingLong(String userId, String groupingId, Long sessionId, String creatorId, Long startTime, Long endTime, String sessionName) {
        BlackboardListRecordingLong request = new ObjectFactory().createBlackboardListRecordingLong();
        if (userId == null && groupingId == null && sessionId == null && creatorId == null && startTime == null && endTime == null && sessionName == null) {
            throw new IllegalStateException("You must specify at least one piece of criteria");
        }
        if (userId != null) {
            request.setUserId(userId);
        }
        if (groupingId != null) {
            request.setGroupingId(groupingId);
        }
        if (sessionId != null) {
            request.setSessionId(sessionId);
        }
        if (creatorId != null) {
            request.setCreatorId(creatorId);
        }
        if (startTime != null) {
            request.setStartTime(startTime);
        }
        if (endTime != null) {
            request.setEndTime(endTime);
        }
        if (sessionName != null) {
            request.setSessionName(sessionName);
        }
        BlackboardListRecordingLongResponseCollection response = (BlackboardListRecordingLongResponseCollection)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListRecordingLong", (Object)request);
        return response.getRecordingLongResponses();
    }

    public List<BlackboardRecordingShortResponse> getRecordingShort(String userId, String groupingId, Long sessionId, String creatorId, Long startTime, Long endTime, String sessionName) {
        BlackboardListRecordingShort request = new ObjectFactory().createBlackboardListRecordingShort();
        if (userId == null && groupingId == null && sessionId == null && creatorId == null && startTime == null && endTime == null && sessionName == null) {
            throw new IllegalStateException("You must specify at least one piece of criteria");
        }
        if (userId != null) {
            request.setUserId(userId);
        }
        if (groupingId != null) {
            request.setGroupingId(groupingId);
        }
        if (sessionId != null) {
            request.setSessionId(sessionId);
        }
        if (creatorId != null) {
            request.setCreatorId(creatorId);
        }
        if (startTime != null) {
            request.setStartTime(startTime);
        }
        if (endTime != null) {
            request.setEndTime(endTime);
        }
        if (sessionName != null) {
            request.setSessionName(sessionName);
        }
        BlackboardListRecordingShortResponseCollection response = (BlackboardListRecordingShortResponseCollection)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListRecordingShort", (Object)request);
        return response.getRecordingShortResponses();
    }

    public boolean removeRecording(long recordingId) {
        BlackboardRemoveRecording request = new ObjectFactory().createBlackboardRemoveRecording();
        request.setRecordingId(recordingId);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/RemoveRecording", (Object)request));
    }

    public String buildRecordingUrl(long recordingId) {
        BlackboardBuildRecordingUrl request = new ObjectFactory().createBlackboardBuildRecordingUrl();
        request.setRecordingId(recordingId);
        BlackboardUrlResponse response = (BlackboardUrlResponse)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/BuildRecordingUrl", (Object)request);
        return response.getUrl();
    }

    public boolean updateRecordingSecureSignOn(long recordingId, boolean secureSignOn) {
        BlackboardSetRecordingSecureSignOn request = new ObjectFactory().createBlackboardSetRecordingSecureSignOn();
        request.setRecordingId(recordingId);
        request.setSecureSignOn(secureSignOn);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/SetRecordingSecureSignOn", (Object)request));
    }
}

