/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.callback;

import org.jasig.portlet.blackboardvcportlet.data.ServerConfiguration;
import org.jasig.portlet.blackboardvcportlet.service.RecordingService;
import org.jasig.portlet.blackboardvcportlet.service.ServerConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BlackboardVCPortletCallbackController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private RecordingService recordingService;
    private ServerConfigurationService serverConfigurationService;

    @Autowired
    public void setServerConfigurationService(ServerConfigurationService value) {
        this.serverConfigurationService = value;
    }

    @Autowired
    public void setRecordingService(RecordingService recordingService) {
        this.recordingService = recordingService;
    }

    @RequestMapping(value={"/recCallback/{securityToken:.*}"})
    public ModelAndView callback(@PathVariable(value="securityToken") String securityToken, @RequestParam(value="session_id") long sessionId, @RequestParam(value="room_opened_millis") long roomOpenedMillis, @RequestParam(value="room_closed_millis") long roomClosedMillis, @RequestParam(value="rec_playback_link") String recPlaybackLink) throws Exception {
        ServerConfiguration serverConfiguration = this.serverConfigurationService.getServerConfiguration();
        if (serverConfiguration.getRandomCallbackUrl().equalsIgnoreCase(securityToken)) {
            if (recPlaybackLink != null && recPlaybackLink.length() > 0) {
                this.recordingService.updateSessionRecordings(sessionId, roomOpenedMillis, roomClosedMillis);
            }
        } else {
            this.logger.error("Invalid callback URL provided. Expected :" + serverConfiguration.getRandomCallbackUrl() + "; Received : " + securityToken);
            throw new ResourceNotFoundException();
        }
        return new ModelAndView("callback");
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public class ResourceNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

