/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import java.beans.PropertyEditorSupport;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.util.StringUtils;

public class CustomDateMidnightEditor
extends PropertyEditorSupport {
    private final DateTimeFormatter dateFormat;
    private final boolean allowEmpty;
    private final int exactDateLength;

    public CustomDateMidnightEditor(DateTimeFormatter dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
        this.exactDateLength = -1;
    }

    public CustomDateMidnightEditor(DateTimeFormatter dateFormat, boolean allowEmpty, int exactDateLength) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
        this.exactDateLength = exactDateLength;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            if (text != null && this.exactDateLength >= 0 && text.length() != this.exactDateLength) {
                throw new IllegalArgumentException("Could not parse date: it is not exactly" + this.exactDateLength + "characters long");
            }
            this.setValue(this.dateFormat.parseDateTime(text).toDateMidnight());
        }
    }

    @Override
    public String getAsText() {
        DateMidnight value = (DateMidnight)this.getValue();
        return value != null ? this.dateFormat.print((ReadableInstant)value) : "";
    }
}

