/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import com.google.common.collect.Ordering;
import java.beans.PropertyEditor;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.RecordingMode;
import org.jasig.portlet.blackboardvcportlet.data.ServerConfiguration;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.ConferenceUserDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.CustomDateMidnightEditor;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.CustomTimeEditor;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.MultimediaDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.ViewSessionListController;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceUserService;
import org.jasig.portlet.blackboardvcportlet.service.ServerConfigurationService;
import org.jasig.portlet.blackboardvcportlet.service.SessionForm;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.joda.time.DateMidnight;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class SessionCreateEditController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConferenceUserService conferenceUserService;
    private ServerConfigurationService serverConfigurationService;
    private SessionService sessionService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ViewSessionListController viewController;
    @Value(value="${maxuploadsize}")
    private Integer maxFileUploadSize;
    @Value(value="${presentationFileTypes}")
    private String presentationFileTypes;

    @Autowired
    public void setConferenceUserService(ConferenceUserService conferenceUserService) {
        this.conferenceUserService = conferenceUserService;
    }

    @Autowired
    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    @Autowired
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("MM/dd/yyyy").toFormatter();
        binder.registerCustomEditor(DateMidnight.class, (PropertyEditor)new CustomDateMidnightEditor(formatter, false));
        DateTimeFormatter formatter2 = new DateTimeFormatterBuilder().appendPattern("HH:mm").toFormatter();
        binder.registerCustomEditor(LocalTime.class, (PropertyEditor)new CustomTimeEditor(formatter2, false));
    }

    @ModelAttribute(value="recordingModes")
    public RecordingMode[] getRecordingModes() {
        return RecordingMode.values();
    }

    @RenderMapping
    public String displayNewSessionForm(ModelMap model) throws PortletModeException {
        ServerConfiguration serverConfiguration = this.serverConfigurationService.getServerConfiguration();
        model.put((Object)"serverConfiguration", (Object)serverConfiguration);
        if (!model.containsKey((Object)"sessionForm")) {
            SessionForm sessionForm = new SessionForm(serverConfiguration);
            model.addAttribute("sessionForm", (Object)sessionForm);
        }
        return "createEditSession";
    }

    @RenderMapping(params={"action=editSession"})
    public String displayEditSessionForm(RenderRequest request, ModelMap model, @RequestParam long sessionId, @RequestParam(required=false) String presentationUploadError, @RequestParam(required=false) String multimediaUploadError, @RequestParam(required=false) String deleteMultimediaError, @RequestParam(value="needToSendInitialEmail", defaultValue="false", required=false) boolean needToSendInitialEmail) throws PortletModeException {
        if (WindowState.NORMAL.equals((Object)request.getWindowState())) {
            return this.viewController.view((PortletRequest)request, model, null, null);
        }
        ServerConfiguration serverConfiguration = this.serverConfigurationService.getServerConfiguration();
        model.put((Object)"serverConfiguration", (Object)serverConfiguration);
        Session session = this.sessionService.getSession(sessionId);
        if (!model.containsKey((Object)"sessionForm")) {
            SessionForm sessionForm = new SessionForm(session);
            sessionForm.setNeedToSendInitialEmail(needToSendInitialEmail);
            model.addAttribute("sessionForm", (Object)sessionForm);
        }
        Set sessionChairs = this.sessionService.getSessionChairs(session);
        model.addAttribute("sessionChairs", (Object)Ordering.from((Comparator)ConferenceUserDisplayComparator.INSTANCE).sortedCopy((Iterable)sessionChairs));
        Set sessionNonChairs = this.sessionService.getSessionNonChairs(session);
        model.addAttribute("sessionNonChairs", (Object)Ordering.from((Comparator)ConferenceUserDisplayComparator.INSTANCE).sortedCopy((Iterable)sessionNonChairs));
        Set sessionMultimedia = this.sessionService.getSessionMultimedia(session);
        model.addAttribute("sessionMultimedia", (Object)Ordering.from((Comparator)MultimediaDisplayComparator.INSTANCE).sortedCopy((Iterable)sessionMultimedia));
        model.addAttribute("presentationFileTypes", (Object)this.presentationFileTypes);
        model.addAttribute("presentation", (Object)session.getPresentation());
        if (presentationUploadError != null) {
            model.addAttribute("presentationUploadError", (Object)presentationUploadError);
        }
        if (multimediaUploadError != null) {
            model.addAttribute("multimediaUploadError", (Object)multimediaUploadError);
        }
        if (deleteMultimediaError != null) {
            model.addAttribute("deleteMultimediaError", (Object)deleteMultimediaError);
        }
        return "createEditSession";
    }

    @ActionMapping(params={"action=saveSession"})
    public void saveSession(ActionResponse response, @Valid SessionForm session, BindingResult bindingResult) throws PortletModeException {
        if (bindingResult.hasErrors()) {
            if (session.isNewSession()) {
                response.setPortletMode(PortletMode.EDIT);
            } else {
                response.setRenderParameter("sessionId", Long.toString(session.getSessionId()));
                response.setRenderParameter("action", "editSession");
                response.setPortletMode(PortletMode.EDIT);
            }
        } else {
            ConferenceUser conferenceUser = this.conferenceUserService.getCurrentConferenceUser();
            this.sessionService.createOrUpdateSession(conferenceUser, session);
            response.setPortletMode(PortletMode.VIEW);
        }
    }

    @ActionMapping(params={"action=deleteSessions"})
    public void deleteSession(ActionResponse response, Locale locale, @RequestParam(required=false) long[] deleteSession) throws PortletModeException {
        if (deleteSession == null) {
            response.setRenderParameter("deleteSessionError", this.messageSource.getMessage("error.nothingselected", null, locale));
        } else {
            for (long sessionId : deleteSession) {
                this.sessionService.removeSession(sessionId);
            }
        }
        response.setPortletMode(PortletMode.VIEW);
    }

    @ActionMapping(params={"action=deletePresentation"})
    public void deletePresentation(ActionResponse response, Locale locale, @RequestParam long sessionId) throws PortletModeException {
        this.sessionService.deletePresentation(sessionId);
        response.setPortletMode(PortletMode.VIEW);
        response.setRenderParameter("sessionId", Long.toString(sessionId));
        response.setRenderParameter("action", "viewSession");
    }

    @ActionMapping(params={"action=Upload Presentation"})
    public void uploadPresentation(ActionResponse response, Locale locale, @RequestParam long sessionId, @RequestParam MultipartFile presentationUpload, @RequestParam boolean needToSendInitialEmail) throws PortletModeException {
        String fileExtension = StringUtils.substringAfter((String)presentationUpload.getOriginalFilename(), (String)".").toLowerCase();
        if (presentationUpload.getSize() < 1L) {
            response.setRenderParameter("presentationUploadError", this.messageSource.getMessage("error.uploadfilenotselected", null, locale));
        } else if (presentationUpload.getSize() > (long)this.maxFileUploadSize.intValue()) {
            response.setRenderParameter("presentationUploadError", this.messageSource.getMessage("error.uploadfilesizetoobig", null, locale));
        } else if (fileExtension.length() == 0 || !this.presentationFileTypes.contains(fileExtension)) {
            response.setRenderParameter("presentationUploadError", this.messageSource.getMessage("error.uploadfileextensionswrong", null, locale));
        } else {
            this.sessionService.addPresentation(sessionId, presentationUpload);
        }
        response.setPortletMode(PortletMode.VIEW);
        response.setRenderParameter("sessionId", Long.toString(sessionId));
        response.setRenderParameter("action", "viewSession");
        response.setRenderParameter("needToSendInitialEmail", Boolean.toString(needToSendInitialEmail));
    }

    @ActionMapping(params={"action=Delete Presentation"})
    public void deletePresentation(ActionResponse response, @RequestParam long sessionId, @RequestParam boolean needToSendInitialEmail) throws PortletModeException {
        this.sessionService.deletePresentation(sessionId);
        response.setPortletMode(PortletMode.EDIT);
        response.setRenderParameter("sessionId", Long.toString(sessionId));
        response.setRenderParameter("action", "editSession");
        response.setRenderParameter("needToSendInitialEmail", Boolean.toString(needToSendInitialEmail));
    }
}

