/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import java.util.Locale;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import org.jasig.portlet.blackboardvcportlet.data.SessionRecording;
import org.jasig.portlet.blackboardvcportlet.service.RecordingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class SessionRecordingEditController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RecordingService recordingService;
    @Autowired
    private MessageSource messageSource;

    @Autowired
    public void setRecordingService(RecordingService recordingService) {
        this.recordingService = recordingService;
    }

    @RenderMapping(params={"action=editRecording"})
    public String displayEditSessionForm(ModelMap model, @RequestParam long recordingId) throws PortletModeException {
        SessionRecording sessionRecording = this.recordingService.getSessionRecording(recordingId);
        model.put((Object)"recording", (Object)sessionRecording);
        return "BlackboardVCPortlet_editRecording";
    }

    @ActionMapping(params={"action=saveRecording"})
    public void deleteSession(ActionResponse response, @RequestParam long recordingId, @RequestParam String roomName) throws PortletModeException {
        this.recordingService.updateSessionRecordingName(recordingId, roomName);
        response.setPortletMode(PortletMode.VIEW);
    }

    @ActionMapping(params={"action=deleteRecordings"})
    public void deleteSession(ActionResponse response, Locale locale, @RequestParam(required=false) long[] deleteRecording) throws PortletModeException {
        if (deleteRecording == null) {
            response.setRenderParameter("deleteRecordingError", this.messageSource.getMessage("error.nothingselected", null, locale));
        } else {
            for (long recordingId : deleteRecording) {
                this.recordingService.removeRecording(recordingId);
            }
        }
        response.setPortletMode(PortletMode.VIEW);
    }
}

