/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.jasig.portlet.blackboardvcportlet.dao.SessionDao;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.SessionTelephony;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.ConferenceUserDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.MultimediaDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.SessionRecordingDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.ViewSessionListController;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceUserService;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewSessionController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConferenceUserService conferenceUserService;
    private SessionService sessionService;
    private SessionDao sessionDao;
    private String telephonyEnabled;
    @Autowired
    private ViewSessionListController viewController;

    @Autowired
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Value(value="${telephonyEnabled}")
    public void setTelephonyEnabled(String telephonyEnabled) {
        this.telephonyEnabled = telephonyEnabled;
    }

    @Autowired
    public void setConferenceUserService(ConferenceUserService conferenceUserService) {
        this.conferenceUserService = conferenceUserService;
    }

    @Autowired
    public void setSessionDao(SessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    @RenderMapping(params={"action=viewSession"})
    public String viewSession(PortletRequest request, @RequestParam long sessionId, ModelMap model, @RequestParam(required=false) String presentationUploadError) {
        if (WindowState.NORMAL.equals((Object)request.getWindowState())) {
            return this.viewController.view(request, model, null, null);
        }
        Session session = this.sessionService.getSession(sessionId);
        Set sessionChairs = this.sessionService.getSessionChairs(session);
        model.addAttribute("sessionChairs", (Object)ImmutableSortedSet.copyOf((Comparator)ConferenceUserDisplayComparator.INSTANCE, (Collection)sessionChairs));
        Set sessionNonChairs = this.sessionService.getSessionNonChairs(session);
        model.addAttribute("sessionNonChairs", (Object)ImmutableSortedSet.copyOf((Comparator)ConferenceUserDisplayComparator.INSTANCE, (Collection)sessionNonChairs));
        Set sessionMultimedias = this.sessionDao.getSessionMultimedias(session);
        model.addAttribute("multimedias", (Object)ImmutableSortedSet.copyOf((Comparator)MultimediaDisplayComparator.INSTANCE, (Collection)sessionMultimedias));
        Set sessionRecordings = this.sessionDao.getSessionRecordings(session);
        model.addAttribute("recordings", (Object)ImmutableSortedSet.copyOf((Comparator)SessionRecordingDisplayComparator.INSTANCE, (Collection)sessionRecordings));
        SessionTelephony sessionTelephony = this.sessionService.getSessionTelephony(session);
        model.addAttribute("sessionTelephony", (Object)sessionTelephony);
        ConferenceUser conferenceUser = this.conferenceUserService.getCurrentConferenceUser();
        this.sessionService.populateLaunchUrl(conferenceUser, session);
        model.addAttribute("session", (Object)session);
        model.addAttribute("telephonyEnabled", (Object)this.telephonyEnabled);
        if (presentationUploadError != null) {
            model.addAttribute("presentationUploadError", (Object)presentationUploadError);
        }
        return "viewSession";
    }
}

