/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import ch.lambdaj.Lambda;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.jasig.portlet.blackboardvcportlet.dao.ConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.dao.SessionDao;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.SessionDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.SessionRecordingDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceUserService;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewSessionListController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConferenceUserService conferenceUserService;
    private SessionDao sessionDao;
    private SessionService sessionService;
    private ConferenceUserDao conferenceUserDao;

    @Autowired
    public void setConferenceUserService(ConferenceUserService conferenceUserService) {
        this.conferenceUserService = conferenceUserService;
    }

    @Autowired
    public void setSessionService(SessionService service) {
        this.sessionService = service;
    }

    @Autowired
    public void setSessionDao(SessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    @Autowired
    public void setConferenceUserDao(ConferenceUserDao conferenceUserDao) {
        this.conferenceUserDao = conferenceUserDao;
    }

    @RenderMapping
    public String view(PortletRequest request, ModelMap model, @RequestParam(required=false) String deleteSessionError, @RequestParam(required=false) String deleteRecordingError) {
        ConferenceUser conferenceUser = this.conferenceUserService.getCurrentConferenceUser();
        HashSet sessions = new HashSet();
        Set ownedSessionsForUser = this.conferenceUserDao.getOwnedSessionsForUser(conferenceUser);
        sessions.addAll(ownedSessionsForUser);
        Set chairedSessionsForUser = this.conferenceUserDao.getChairedSessionsForUser(conferenceUser);
        sessions.addAll(chairedSessionsForUser);
        Set nonChairedSessionsForUser = this.conferenceUserDao.getNonChairedSessionsForUser(conferenceUser);
        sessions.addAll(nonChairedSessionsForUser);
        BaseMatcher<DateTime> afterNow = new BaseMatcher<DateTime>(){

            public void describeTo(Description arg0) {
            }

            public boolean matches(Object arg0) {
                DateTime now = DateTime.now();
                DateTime arg = (DateTime)arg0;
                return arg.isAfter((ReadableInstant)now);
            }
        };
        BaseMatcher<DateTime> beforeOrIsNow = new BaseMatcher<DateTime>(){

            public void describeTo(Description arg0) {
            }

            public boolean matches(Object arg0) {
                DateTime arg = (DateTime)arg0;
                DateTime now = DateTime.now();
                return arg.isBefore((ReadableInstant)now) || arg.isEqualNow();
            }
        };
        List upcomingSessions = Lambda.filter((Matcher)Lambda.having((Object)((Session)Lambda.on(Session.class)).getEndTime(), (Matcher)afterNow), sessions);
        List completedSessions = Lambda.filter((Matcher)Lambda.having((Object)((Session)Lambda.on(Session.class)).getEndTime(), (Matcher)beforeOrIsNow), sessions);
        model.addAttribute("completedSessions", (Object)Ordering.from((Comparator)SessionDisplayComparator.INSTANCE).sortedCopy((Iterable)completedSessions));
        model.addAttribute("upcomingSessions", (Object)Ordering.from((Comparator)SessionDisplayComparator.INSTANCE).sortedCopy((Iterable)upcomingSessions));
        if (deleteSessionError != null) {
            model.addAttribute("deleteSessionError", (Object)deleteSessionError);
        }
        if (deleteRecordingError != null) {
            model.addAttribute("deleteRecordingError", (Object)deleteRecordingError);
        }
        HashSet recordings = new HashSet();
        for (Session session : sessions) {
            Set sessionRecordings = this.sessionDao.getSessionRecordings(session);
            recordings.addAll(sessionRecordings);
            this.sessionService.populateLaunchUrl(conferenceUser, session);
        }
        model.addAttribute("recordings", (Object)Ordering.from((Comparator)SessionRecordingDisplayComparator.INSTANCE).sortedCopy(recordings));
        if (WindowState.MAXIMIZED.equals((Object)request.getWindowState())) {
            return "viewSessionsMax";
        }
        return "viewSessionsNormal";
    }
}

