/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.security;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceUserService;
import org.jasig.portlet.blackboardvcportlet.security.PermissionTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.util.ClassUtils;

public class DelegatingPermissionEvaluator
implements PermissionEvaluator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConferenceUserService conferenceUserService;
    private Map<Class<Object>, PermissionTester<Object>> permissionTesters;
    private Map<Class<? extends Object>, PermissionTester<Object>> permissionTesterResolutionCache;

    @Autowired
    public void setConferenceUserService(ConferenceUserService conferenceUserService) {
        this.conferenceUserService = conferenceUserService;
    }

    @Autowired
    public void setPermissionTesters(Set<PermissionTester<Object>> permissionTesters) {
        ImmutableMap.Builder testersBuilder = ImmutableMap.builder();
        for (PermissionTester<Object> permissionTester : permissionTesters) {
            testersBuilder.put(permissionTester.getDomainObjectType(), permissionTester);
        }
        this.permissionTesterResolutionCache = new ConcurrentHashMap<Class<? extends Object>, PermissionTester<Object>>();
        this.permissionTesters = testersBuilder.build();
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        this.logger.debug("Does {} have {} on {}", new Object[]{authentication, permission, targetDomainObject});
        ConferenceUser user = this.conferenceUserService.getConferenceUser(authentication);
        Class<?> targetType = targetDomainObject.getClass();
        PermissionTester<Object> tester = this.resolvePermissionTester(targetType);
        return tester.hasPermission(user, targetDomainObject, permission);
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetTypeName, Object permission) {
        this.logger.debug("Does {} have {} on {} - {}", new Object[]{authentication, permission, targetTypeName, targetId});
        ConferenceUser user = this.conferenceUserService.getConferenceUser(authentication);
        Class<?> targetType = this.getTargetType(targetTypeName);
        PermissionTester<Object> tester = this.resolvePermissionTester(targetType);
        return tester.hasPermissionById(user, targetId, permission);
    }

    private Class<?> getTargetType(String targetTypeName) {
        try {
            return ClassUtils.forName((String)targetTypeName, null);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Permission target '" + targetTypeName + "' does not exist", e);
        }
    }

    private PermissionTester<Object> resolvePermissionTester(Class<? extends Object> targetType) {
        PermissionTester<Object> tester = this.permissionTesterResolutionCache.get(targetType);
        if (tester != null) {
            return tester;
        }
        for (Map.Entry<Class<Object>, PermissionTester<Object>> permissionTesterEntry : this.permissionTesters.entrySet()) {
            Class<Object> testerType = permissionTesterEntry.getKey();
            if (!testerType.isAssignableFrom(targetType)) continue;
            tester = permissionTesterEntry.getValue();
            break;
        }
        if (tester == null) {
            this.logger.warn("No PermissionTester registered for {}, AlwaysDenyPermissionTester will be used for this type", targetType);
            tester = AlwaysDenyPermissionTester.INSTANCE;
        }
        this.permissionTesterResolutionCache.put(targetType, tester);
        return tester;
    }

    private static final class AlwaysDenyPermissionTester
    implements PermissionTester<Object> {
        public static final AlwaysDenyPermissionTester INSTANCE = new AlwaysDenyPermissionTester();

        private AlwaysDenyPermissionTester() {
        }

        @Override
        public Class<Object> getDomainObjectType() {
            return Object.class;
        }

        @Override
        public boolean hasPermission(ConferenceUser user, Object targetDomainObject, Object permission) {
            return false;
        }

        @Override
        public boolean hasPermissionById(ConferenceUser user, Serializable targetId, Object permission) {
            return false;
        }
    }
}

