/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.security;

import java.io.Serializable;
import java.util.Set;
import org.jasig.portlet.blackboardvcportlet.dao.SessionDao;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.security.PermissionTester;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SessionPermissionTester
implements PermissionTester<Session> {
    public static final String VIEW = "view";
    public static final String EDIT = "edit";
    public static final String DELETE = "delete";
    private SessionDao sessionDao;

    @Autowired
    public void setSessionDao(SessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    @Override
    public Class<Session> getDomainObjectType() {
        return Session.class;
    }

    @Override
    public boolean hasPermission(ConferenceUser user, Session session, Object permission) {
        String permissionStr = String.valueOf(permission);
        if (VIEW.equalsIgnoreCase(permissionStr)) {
            if (session.getCreator().equals(user)) {
                return true;
            }
            if (this.isChair(user, session)) {
                return true;
            }
            return this.isNonChair(user, session);
        }
        if (EDIT.equalsIgnoreCase(permissionStr)) {
            if (session.getCreator().equals(user)) {
                return true;
            }
            return this.isChair(user, session);
        }
        if (DELETE.equalsIgnoreCase(permissionStr)) {
            return session.getCreator().equals(user);
        }
        return false;
    }

    @Override
    public boolean hasPermissionById(ConferenceUser user, Serializable targetId, Object permission) {
        Session session = this.sessionDao.getSession(((Long)targetId).longValue());
        return this.hasPermission(user, session, permission);
    }

    private boolean isNonChair(ConferenceUser user, Session session) {
        Set sessionNonChairs = this.sessionDao.getSessionNonChairs(session);
        return sessionNonChairs.contains(user);
    }

    private boolean isChair(ConferenceUser user, Session session) {
        Set sessionChairs = this.sessionDao.getSessionChairs(session);
        return sessionChairs.contains(user);
    }
}

